/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.component.graphicimage.GraphicImageBase;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.HTML;
import org.primefaces.util.Lazy;
import org.primefaces.util.ResourceUtils;

public class GraphicImageRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(context);
        String imageSrc = this.getImageSrc(context, image);
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)imageSrc, null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        this.renderDomEvents(context, (UIComponent)image, HTML.IMG_ATTRS);
        writer.endElement("img");
    }

    protected String getImageSrc(FacesContext context, GraphicImage image) {
        String name = image.getName();
        if (name != null) {
            String library = image.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource resource = handler.createResource(name, library);
            if (resource == null) {
                return "RES_NOT_FOUND";
            }
            if (image.isStream()) {
                String requestPath = resource.getRequestPath();
                return context.getExternalContext().encodeResourceURL(requestPath);
            }
            return ResourceUtils.toBase64(context, resource);
        }
        return DynamicContentSrcBuilder.build(context, (UIComponent)image, image.getValueExpression(GraphicImageBase.PropertyKeys.value.name()), new Lazy<Object>(() -> image.getValue()), image.isCache(), image.isStream());
    }
}

