/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.headerrow;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;

public class HeaderRowRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HeaderRow row = (HeaderRow)component;
        ResponseWriter writer = context.getResponseWriter();
        boolean expandable = row.isExpandable();
        boolean expanded = row.isExpanded();
        Object helperRenderer = context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-rowgroup-header ui-datatable-headerrow ui-widget-header", null);
        if (row.getChildCount() > 0) {
            boolean firstColumn = true;
            for (int i = 0; i < row.getChildCount(); ++i) {
                UIComponent child = (UIComponent)row.getChildren().get(i);
                if (!child.isRendered() || !(child instanceof Column)) continue;
                Column column = (Column)child;
                this.encodeHeaderRowWithColumn(context, column, expandable, expanded, firstColumn);
                firstColumn = false;
            }
        } else {
            DataTable table = (DataTable)component.getParent();
            this.encodeHeaderRowWithoutColumn(context, row, table, expandable, expanded);
        }
        writer.endElement("tr");
        context.getAttributes().put("org.primefaces.HELPER_RENDERER", helperRenderer);
    }

    protected void encodeToggleIcon(FacesContext context, boolean expanded) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String ariaLabel = MessageFactory.getMessage("primefaces.rowgrouptoggler.aria.ROW_GROUP_TOGGLER", new Object[0]);
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)"ui-rowgroup-toggler", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(expanded ? "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-s" : "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-e"), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeHeaderRowWithColumn(FacesContext context, UIColumn column, boolean expandable, boolean expanded, boolean first) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        int rowspan = column.getRowspan();
        int colspan = column.getColspan();
        writer.startElement("td", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (expandable && first) {
            this.encodeToggleIcon(context, expanded);
        }
        column.encodeAll(context);
        writer.endElement("td");
    }

    protected void encodeHeaderRowWithoutColumn(FacesContext context, HeaderRow row, DataTable table, boolean expandable, boolean expanded) throws IOException {
        String field;
        ResponseWriter writer = context.getResponseWriter();
        String style = row.getStyle();
        String styleClass = row.getStyleClass();
        Integer rowspan = row.getRowspan();
        Integer colspan = row.getColspan();
        writer.startElement("td", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (rowspan != null) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan == null) {
            colspan = table.getColumnsCount();
        }
        writer.writeAttribute("colspan", (Object)colspan, null);
        if (expandable) {
            this.encodeToggleIcon(context, expanded);
        }
        String value = LangUtils.isNotBlank(field = row.getField()) ? UIColumn.createValueExpressionFromField(context, table.getVar(), field).getValue(context.getELContext()) : row.getGroupBy();
        writer.writeText((Object)value, null);
        writer.endElement("td");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

