/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.mindmap;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.mindmap.MindmapBase;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.mindmap.MindmapNode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="raphael/raphael.js"), @ResourceDependency(library="primefaces", name="mindmap/mindmap.js")})
public class Mindmap
extends MindmapBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Mindmap";
    public static final String STYLE_CLASS = "ui-mindmap ui-widget ui-widget-content ui-corner-all";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("select", SelectEvent.class).put("dblselect", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private MindmapNode selectedNode;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public MindmapNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedNodeKey(FacesContext context) {
        return (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_nodeKey");
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(context);
        AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
        String eventName = (String)params.get("jakarta.faces.behavior.event");
        if ("select".equals(eventName) || "dblselect".equals(eventName)) {
            MindmapNode node;
            String nodeKey = (String)params.get(clientId + "_nodeKey");
            this.selectedNode = node = "root".equals(nodeKey) ? this.getValue() : this.findNode(this.getValue(), nodeKey);
            super.queueEvent(new SelectEvent<MindmapNode>((UIComponent)this, behaviorEvent.getBehavior(), node));
        }
    }

    protected MindmapNode findNode(MindmapNode searchRoot, String rowKey) {
        String[] paths = rowKey.split("_");
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        searchRoot = searchRoot.getChildren().get(childIndex);
        if (paths.length == 1) {
            return searchRoot;
        }
        String relativeRowKey = rowKey.substring(rowKey.indexOf(95) + 1);
        return this.findNode(searchRoot, relativeRowKey);
    }

    public boolean isNodeSelectRequest(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            return false;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("jakarta.faces.behavior.event");
        return "select".equals(eventName);
    }
}

