/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.overlaypanel;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class OverlayPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OverlayPanel panel = (OverlayPanel)component;
        if (panel.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            this.encodeScript(context, panel);
        }
    }

    protected void encodeMarkup(FacesContext context, OverlayPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-overlaypanel ui-widget ui-widget-content ui-corner-all ui-shadow ui-hidden-container" : "ui-overlaypanel ui-widget ui-widget-content ui-corner-all ui-shadow ui-hidden-container " + styleClass;
        writer.startElement("div", (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-overlaypanel-content", "styleClass");
        if (!panel.isDynamic()) {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, OverlayPanel panel) throws IOException {
        String target = SearchExpressionFacade.resolveClientId(context, (UIComponent)panel, panel.getFor());
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("OverlayPanel", panel).attr("target", target).attr("showEvent", panel.getShowEvent(), null).attr("hideEvent", panel.getHideEvent(), null).callback("onShow", "function()", panel.getOnShow()).callback("onHide", "function()", panel.getOnHide()).attr("my", panel.getMy(), null).attr("at", panel.getAt(), null).attr("collision", panel.getCollision(), null).attr("appendTo", panel.getAppendTo(), null).attr("dynamic", panel.isDynamic(), false).attr("cache", panel.isCache(), true).attr("dismissable", panel.isDismissable(), true).attr("showCloseIcon", panel.isShowCloseIcon(), false).attr("modal", panel.isModal(), false).attr("blockScroll", panel.isBlockScroll(), false).attr("autoHide", panel.isAutoHide(), true).attr("showDelay", panel.getShowDelay(), 0);
        this.encodeClientBehaviors(context, panel);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

