/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.paginator;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.paginator.PaginatorElementRenderer;

public class PageLinksRenderer
implements PaginatorElementRenderer {
    @Override
    public void render(FacesContext context, Pageable pageable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int currentPage = pageable.getPage();
        int pageLinks = pageable.getPageLinks();
        int pageCount = pageable.getPageCount();
        int visiblePages = Math.min(pageLinks, pageCount);
        int start = Math.max(0, currentPage - visiblePages / 2);
        int end = Math.min(pageCount - 1, start + visiblePages - 1);
        int delta = pageLinks - (end - start + 1);
        start = Math.max(0, start - delta);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-paginator-pages", null);
        for (int i = start; i <= end; ++i) {
            String styleClass = currentPage == i ? "ui-paginator-page ui-state-default ui-state-active ui-corner-all" : "ui-paginator-page ui-state-default ui-corner-all";
            writer.startElement("a", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.writeAttribute("tabindex", (Object)0, null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeText((Object)(i + 1), null);
            writer.endElement("a");
        }
        writer.endElement("span");
    }
}

