/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.piechart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.piechart.PieChart;
import org.primefaces.model.charts.pie.PieChartOptions;
import org.primefaces.util.ChartUtils;
import org.primefaces.util.WidgetBuilder;

public class PieChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PieChart chart = (PieChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, PieChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PieChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        PieChartOptions pieOptions = (PieChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeResponsive(context, pieOptions, false);
        writer.write(",\"animation\":{");
        writer.write("\"animateRotate\":" + pieOptions.isAnimateRotate());
        writer.write(",\"animateScale\":" + pieOptions.isAnimateScale());
        writer.write("}");
        if (pieOptions.getCutout() != null) {
            ChartUtils.writeDataValue((Writer)writer, "cutout", pieOptions.getCutout(), true);
        }
        if (pieOptions.getRotation() != null) {
            writer.write(",\"rotation\":" + pieOptions.getRotation());
        }
        if (pieOptions.getCircumference() != null) {
            writer.write(",\"circumference\":" + pieOptions.getCircumference());
        }
        this.encodeElements(context, pieOptions.getElements(), true);
        this.encodeAnimation(context, pieOptions.getAnimation(), true);
        this.encodePlugins(context, pieOptions, true);
        writer.write("}");
    }
}

