/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.poll;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.time.Duration;
import org.primefaces.component.poll.Poll;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class PollRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Poll poll = (Poll)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(poll.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)poll);
            if (poll.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            poll.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        long convertedInterval;
        Poll poll = (Poll)component;
        String clientId = poll.getClientId(context);
        this.renderDummyMarkup(context, component, clientId);
        String request = this.preConfiguredAjaxRequestBuilder(context, poll).params((UIComponent)poll).build();
        Object interval = poll.getInterval();
        if (interval instanceof Number) {
            convertedInterval = ((Number)interval).longValue();
        } else if (interval instanceof Duration) {
            convertedInterval = ((Duration)interval).getSeconds();
        } else if (interval instanceof String) {
            try {
                convertedInterval = Long.parseLong((String)interval);
            }
            catch (NumberFormatException e) {
                throw new FacesException(interval + " is not a valid long for \"interval\" for p:poll", (Throwable)e);
            }
        } else {
            throw new FacesException(interval.getClass() + " is not supported as \"interval\" for p:poll");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Poll", poll).attr("frequency", convertedInterval).attr("autoStart", poll.isAutoStart()).attr("intervalType", poll.getIntervalType(), "second").callback("fn", "function()", request);
        wb.finish();
    }
}

