/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.progressbar;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.PrimeFaces;
import org.primefaces.component.progressbar.ProgressBar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ProgressBarRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        ProgressBar progressBar = (ProgressBar)component;
        String clientId = progressBar.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            PrimeFaces.current().ajax().addCallbackParam(progressBar.getClientId(context) + "_value", progressBar.getValue());
        }
        this.decodeBehaviors(context, (UIComponent)progressBar);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ProgressBar progressBar = (ProgressBar)component;
        this.encodeMarkup(context, progressBar);
        if (!progressBar.isDisplayOnly()) {
            this.encodeScript(context, progressBar);
        }
    }

    protected void encodeMarkup(FacesContext context, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String mode = progressBar.getMode();
        int value = progressBar.getValue();
        String labelTemplate = progressBar.getLabelTemplate();
        String title = progressBar.getTitle();
        String style = progressBar.getStyle();
        String styleClass = progressBar.getStyleClass();
        styleClass = styleClass == null ? "ui-progressbar ui-widget ui-widget-content ui-corner-all" : "ui-progressbar ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = styleClass + " " + ("determinate".equals(mode) ? "ui-progressbar-determinate" : "ui-progressbar-indeterminate");
        if (progressBar.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("id", (Object)progressBar.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("class", (Object)"ui-progressbar-value ui-widget-header ui-corner-all", null);
        if (value != 0) {
            writer.writeAttribute("style", (Object)("display:block;width:" + value + "%"), style);
        }
        writer.endElement("div");
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("class", (Object)"ui-progressbar-label", null);
        if (labelTemplate != null) {
            writer.writeAttribute("style", (Object)"display:block", style);
            writer.writeText((Object)labelTemplate.replace("{value}", String.valueOf(value)), null);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ProgressBar progressBar) throws IOException {
        boolean isAjax = progressBar.isAjax();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ProgressBar", progressBar).attr("initialValue", progressBar.getValue()).attr("ajax", isAjax).attr("labelTemplate", progressBar.getLabelTemplate(), null).attr("animationDuration", progressBar.getAnimationDuration()).attr("global", progressBar.isGlobal(), true);
        if (isAjax) {
            wb.attr("interval", progressBar.getInterval());
            this.encodeClientBehaviors(context, progressBar);
        }
        wb.finish();
    }
}

