/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resetinput;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class ResetInputActionListener
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private ValueExpression target;
    private ValueExpression clearModel;

    public ResetInputActionListener() {
    }

    public ResetInputActionListener(ValueExpression target, ValueExpression clearModel) {
        this.target = target;
        this.clearModel = clearModel;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        String expressions = (String)this.target.getValue(elContext);
        boolean resetModel = false;
        if (this.clearModel != null) {
            resetModel = this.clearModel.isLiteralText() ? Boolean.parseBoolean(this.clearModel.getValue(context.getELContext()).toString()) : (Boolean)this.clearModel.getValue(context.getELContext());
        }
        ResetInputVisitCallback visitCallback = resetModel ? ResetInputVisitCallback.INSTANCE_CLEAR_MODEL : ResetInputVisitCallback.INSTANCE;
        List<UIComponent> components = SearchExpressionFacade.resolveComponents(context, event.getComponent(), expressions);
        for (int i = 0; i < components.size(); ++i) {
            UIComponent component = components.get(i);
            component.visitTree(visitContext, (VisitCallback)visitCallback);
        }
    }
}

