/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.scatterchart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.scatterchart.ScatterChart;
import org.primefaces.model.charts.line.LineChartOptions;
import org.primefaces.util.WidgetBuilder;

public class ScatterChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ScatterChart chart = (ScatterChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, ScatterChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ScatterChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        LineChartOptions lineOptions = (LineChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeResponsive(context, lineOptions, false);
        writer.write(",\"showLines\":" + lineOptions.isShowLines());
        writer.write(",\"spanGaps\":" + lineOptions.isSpanGaps());
        this.encodeScales(context, type, lineOptions.getScales(), true);
        this.encodeElements(context, lineOptions.getElements(), true);
        this.encodeAnimation(context, lineOptions.getAnimation(), true);
        this.encodePlugins(context, lineOptions, true);
        writer.write("}");
    }
}

