/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.scrolltop;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.scrolltop.ScrollTop;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ScrollTopRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ScrollTop scrollTop = (ScrollTop)component;
        this.encodeMarkup(context, scrollTop);
        this.encodeScript(context, scrollTop);
    }

    protected void encodeMarkup(FacesContext context, ScrollTop scrollTop) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-scrolltop ui-widget").add(scrollTop.getStyleClass()).add("parent".equals(scrollTop.getTarget()), "ui-scrolltop-sticky").build();
        String style = scrollTop.getStyle() != null ? "display: none;" + scrollTop.getStyle() : "display: none;";
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)scrollTop.getClientId(context), "id");
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"0", "tabindex");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("style", (Object)style, "style");
        writer.startElement("span", (UIComponent)scrollTop);
        writer.writeAttribute("class", (Object)("ui-scrolltop-icon " + scrollTop.getIcon()), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeScript(FacesContext context, ScrollTop scrollTop) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ScrollTop", scrollTop).attr("target", scrollTop.getTarget()).attr("threshold", scrollTop.getThreshold()).attr("behavior", scrollTop.getBehavior());
        wb.finish();
    }
}

