/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectbooleanbutton;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.util.Objects;
import org.primefaces.component.selectbooleanbutton.SelectBooleanButton;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class SelectBooleanButtonRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        SelectBooleanButton button = (SelectBooleanButton)component;
        if (!this.shouldDecode((UIInput)button)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)button);
        String clientId = button.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        boolean checked = "on".equalsIgnoreCase(submittedValue);
        button.setSubmittedValue(checked);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectBooleanButton button = (SelectBooleanButton)component;
        this.calculateLabels(context, button);
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    private void calculateLabels(FacesContext context, SelectBooleanButton button) {
        boolean hasIcon;
        boolean hasLabel;
        boolean bl = hasLabel = LangUtils.isNotBlank(button.getOnLabel()) || LangUtils.isNotBlank(button.getOffLabel());
        if (hasLabel) {
            return;
        }
        boolean bl2 = hasIcon = LangUtils.isNotBlank(button.getOnIcon()) || LangUtils.isNotBlank(button.getOffIcon());
        if (!hasIcon) {
            button.setOnLabel(MessageFactory.getMessage("primefaces.switch.LABEL_ON", new Object[0]));
            button.setOffLabel(MessageFactory.getMessage("primefaces.switch.LABEL_OFF", new Object[0]));
        }
    }

    protected void encodeMarkup(FacesContext context, SelectBooleanButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        boolean checked = Boolean.parseBoolean(ComponentUtils.getValueToRender(context, (UIComponent)button));
        boolean disabled = button.isDisabled();
        String inputId = clientId + "_input";
        String label = checked ? button.getOnLabel() : button.getOffLabel();
        String icon = checked ? button.getOnIcon() : button.getOffIcon();
        boolean hasIcon = icon != null;
        String title = button.getTitle();
        String style = button.getStyle();
        String styleClass = "ui-selectbooleanbutton " + button.resolveStyleClass(checked, disabled);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("aria-label", (Object)label, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)button);
        this.renderAccessibilityAttributes(context, (UIInput)button);
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.TAB_INDEX);
        this.renderOnchange(context, (UIComponent)button);
        this.renderDomEvents(context, (UIComponent)button, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
        if (hasIcon) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(label)) {
            writer.write(this.getIconOnlyButtonText(title, button.getAriaLabel()));
        } else {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectBooleanButton button) throws IOException {
        String onLabel = button.getOnLabel();
        String offLabel = button.getOffLabel();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectBooleanButton", button).attr("onLabel", this.isValueBlank(onLabel) ? "ui-button" : onLabel).attr("offLabel", this.isValueBlank(offLabel) ? "ui-button" : offLabel).attr("onIcon", button.getOnIcon(), null).attr("offIcon", button.getOffIcon(), null);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        Object convertedValue = ComponentUtils.getConvertedValue(context, component, submittedValue);
        return convertedValue instanceof Boolean ? convertedValue : Boolean.valueOf(Objects.toString(convertedValue));
    }

    @Override
    protected String getHighlighter() {
        return "booleanbutton";
    }
}

