/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import jakarta.faces.context.FacesContext;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.TableExporter;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.model.TreeNode;

public abstract class TreeTableExporter<P, O extends ExporterOptions>
extends TableExporter<TreeTable, P, O> {
    protected TreeTableExporter(O defaultOptions) {
        super(defaultOptions);
    }

    protected TreeTableExporter(O defaultOptions, Set<TableExporter.FacetType> supportedFacetTypes, boolean joinCellComponents) {
        super(defaultOptions, supportedFacetTypes, joinCellComponents);
    }

    @Override
    protected void exportPageOnly(FacesContext context, TreeTable table) {
        int rowsToExport;
        int first = table.getFirst();
        int rows = table.getRows();
        TreeNode root = table.getValue();
        root.setExpanded(true);
        int totalRows = TreeTableExporter.getTreeRowCount(root) - 1;
        if (rows == 0) {
            rows = totalRows;
        }
        if ((rowsToExport = first + rows) > totalRows) {
            rowsToExport = totalRows;
        }
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(context, table, rowIndex);
        }
    }

    @Override
    protected void exportAll(FacesContext context, TreeTable table) {
        int first = table.getFirst();
        TreeNode root = table.getValue();
        root.setExpanded(true);
        int rowCount = TreeTableExporter.getTreeRowCount(root) - 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.exportRow(context, table, rowIndex);
        }
        table.setFirst(first);
    }

    protected void exportRow(FacesContext context, TreeTable table, int rowIndex) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object origVar = requestMap.get(table.getVar());
        Object data = TreeTableExporter.traverseTree(table.getValue(), rowIndex + 1);
        requestMap.put(table.getVar(), data);
        super.addCells(context, table);
        if (origVar != null) {
            requestMap.put(table.getVar(), origVar);
        } else {
            requestMap.remove(table.getVar());
        }
    }

    @Override
    protected void exportSelectionOnly(FacesContext context, TreeTable table) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(context, table, -1);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    if (obj instanceof TreeNode) {
                        TreeNode node = (TreeNode)obj;
                        requestMap.put(var, node.getData());
                    } else {
                        requestMap.put(var, obj);
                    }
                    this.exportRow(context, table, -1);
                }
            } else {
                requestMap.put(var, selection);
                this.exportRow(context, table, -1);
            }
        }
    }

    protected static int getTreeRowCount(TreeNode<?> node) {
        int count = 1;
        if (node.getChildren() != null) {
            for (TreeNode<?> childNode : node.getChildren()) {
                count += TreeTableExporter.getTreeRowCount(childNode);
            }
            return count;
        }
        return count;
    }

    protected static Object traverseTree(TreeNode node, int rowIndex) {
        return TreeTableExporter.traverseTree(node, new AtomicInteger(rowIndex));
    }

    protected static Object traverseTree(TreeNode<?> node, AtomicInteger rowIndex) {
        int index = rowIndex.get();
        rowIndex.decrementAndGet();
        if (index <= 0) {
            return node.getData();
        }
        if (node.getChildren() != null) {
            TreeNode<?> childNode;
            Object data = null;
            Iterator<TreeNode<?>> iterator = node.getChildren().iterator();
            while (iterator.hasNext() && (data = TreeTableExporter.traverseTree(childNode = iterator.next(), rowIndex)) == null) {
            }
            return data;
        }
        return null;
    }
}

