/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.primefaces.cache.CacheProvider;
import org.primefaces.cache.DefaultCacheProvider;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableCSVExporter;
import org.primefaces.component.datatable.export.DataTableExcelExporter;
import org.primefaces.component.datatable.export.DataTableExcelXExporter;
import org.primefaces.component.datatable.export.DataTableExcelXStreamExporter;
import org.primefaces.component.datatable.export.DataTablePDFExporter;
import org.primefaces.component.datatable.export.DataTableXMLExporter;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableCSVExporter;
import org.primefaces.component.treetable.export.TreeTableExcelExporter;
import org.primefaces.component.treetable.export.TreeTableExcelXExporter;
import org.primefaces.component.treetable.export.TreeTableExcelXStreamExporter;
import org.primefaces.component.treetable.export.TreeTablePDFExporter;
import org.primefaces.component.treetable.export.TreeTableXMLExporter;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.metadata.transformer.MetadataTransformer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;
import org.primefaces.util.MapBuilder;
import org.primefaces.validate.bean.ClientValidationConstraint;
import org.primefaces.virusscan.VirusScannerService;
import org.primefaces.webapp.FileUploadChunksServlet;

public class PrimeApplicationContext {
    public static final String INSTANCE_KEY = PrimeApplicationContext.class.getName();
    private static final Logger LOGGER = Logger.getLogger(PrimeApplicationContext.class.getName());
    private final PrimeEnvironment environment;
    private final PrimeConfiguration config;
    private final ClassLoader applicationClassLoader;
    private final Map<Class<?>, Map<String, Object>> enumCacheMap;
    private final Map<Class<?>, Map<String, Object>> constantsCacheMap;
    private final Map<Class<? extends UIComponent>, Map<String, Class<? extends Exporter<?>>>> exporters;
    private final Map<String, ClientValidationConstraint> beanValidationClientConstraintMapping;
    private final List<MetadataTransformer> metadataTransformers;
    private final Lazy<ValidatorFactory> validatorFactory;
    private final Lazy<Validator> validator;
    private final Lazy<CacheProvider> cacheProvider;
    private final Lazy<VirusScannerService> virusScannerService;
    private FileTypeDetector fileTypeDetector;
    private FileUploadDecoder fileUploadDecoder;
    private String fileUploadResumeUrl;

    public PrimeApplicationContext(FacesContext facesContext) {
        this.environment = new PrimeEnvironment(facesContext);
        this.config = new PrimeConfiguration(facesContext, this.environment);
        this.enumCacheMap = new ConcurrentHashMap();
        this.constantsCacheMap = new ConcurrentHashMap();
        this.exporters = new ConcurrentHashMap();
        this.beanValidationClientConstraintMapping = new ConcurrentHashMap<String, ClientValidationConstraint>();
        this.metadataTransformers = new CopyOnWriteArrayList<MetadataTransformer>();
        ClassLoader classLoader = null;
        Object context = facesContext.getExternalContext().getContext();
        if (context != null) {
            try {
                Method getClassLoaderMethod = context.getClass().getMethod("getClassLoader", new Class[0]);
                if (getClassLoaderMethod != null) {
                    classLoader = (ClassLoader)getClassLoaderMethod.invoke(context, new Object[0]);
                }
            }
            catch (AbstractMethodError | IllegalAccessException | NoSuchMethodError | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException getClassLoaderMethod) {
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "An unexpected Exception or Error was thrown when calling facesContext.getExternalContext().getContext().getClassLoader(). Falling back to Thread.currentThread().getContextClassLoader() instead.", t);
            }
        }
        if (classLoader == null) {
            classLoader = LangUtils.getContextClassLoader();
        }
        this.applicationClassLoader = classLoader;
        if (this.config.isBeanValidationEnabled()) {
            this.validatorFactory = new Lazy(Validation::buildDefaultValidatorFactory);
            this.validator = new Lazy(() -> this.validatorFactory.get().getValidator());
        } else {
            this.validatorFactory = null;
            this.validator = null;
        }
        this.virusScannerService = new Lazy(() -> new VirusScannerService(this.applicationClassLoader));
        this.cacheProvider = new Lazy(() -> {
            String cacheProviderConfigValue = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("primefaces.CACHE_PROVIDER");
            if (cacheProviderConfigValue == null) {
                return new DefaultCacheProvider();
            }
            try {
                Class cacheProviderClazz = LangUtils.loadClassForName(cacheProviderConfigValue);
                return (CacheProvider)cacheProviderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new FacesException((Throwable)ex);
            }
        });
        this.resolveFileUploadDecoder();
        this.resolveFileUploadResumeUrl(facesContext);
        this.resolveFileTypeDetector();
        this.registerDefaultExporters();
    }

    private void registerDefaultExporters() {
        MapBuilder.builder(this.exporters).put(DataTable.class, MapBuilder.builder().put("xls", DataTableExcelExporter.class).put("pdf", DataTablePDFExporter.class).put("csv", DataTableCSVExporter.class).put("xml", DataTableXMLExporter.class).put("xlsx", DataTableExcelXExporter.class).put("xlsxstream", DataTableExcelXStreamExporter.class).build()).put(TreeTable.class, MapBuilder.builder().put("xls", TreeTableExcelExporter.class).put("pdf", TreeTablePDFExporter.class).put("csv", TreeTableCSVExporter.class).put("xml", TreeTableXMLExporter.class).put("xlsx", TreeTableExcelXExporter.class).put("xlsxstream", TreeTableExcelXStreamExporter.class).build());
    }

    private void resolveFileTypeDetector() {
        ServiceLoader<FileTypeDetector> loader = ServiceLoader.load(FileTypeDetector.class, this.applicationClassLoader);
        final ArrayList<FileTypeDetector> detectors = new ArrayList<FileTypeDetector>();
        for (FileTypeDetector detector : loader) {
            detectors.add(detector);
        }
        this.fileTypeDetector = new FileTypeDetector(){

            @Override
            public String probeContentType(Path path) throws IOException {
                for (FileTypeDetector detector : detectors) {
                    String result = detector.probeContentType(path);
                    if (result == null) continue;
                    return result;
                }
                return Files.probeContentType(path);
            }
        };
    }

    private void resolveFileUploadResumeUrl(FacesContext facesContext) {
        if (!this.getEnvironment().isAtLeastServlet30()) {
            return;
        }
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            ServletContext servletContext = ((HttpServletRequest)request).getServletContext();
            if (servletContext == null) {
                return;
            }
            Map servletRegistrations = servletContext.getServletRegistrations();
            if (servletRegistrations == null || servletRegistrations.isEmpty()) {
                return;
            }
            this.fileUploadResumeUrl = servletRegistrations.values().stream().filter(s -> FileUploadChunksServlet.class.getName().equals(s.getClassName())).findFirst().map(ServletRegistration::getMappings).map(Collection::stream).flatMap(Stream::findFirst).map(s -> facesContext.getExternalContext().getApplicationContextPath() + s).orElse(null);
        }
    }

    private void resolveFileUploadDecoder() {
        String uploader = this.config.getUploader();
        if ("auto".equals(uploader)) {
            uploader = this.environment.isAtLeastJsf22() ? "native" : "commons";
        }
        String finalUploader = uploader;
        this.fileUploadDecoder = StreamSupport.stream(ServiceLoader.load(FileUploadDecoder.class, this.applicationClassLoader).spliterator(), false).filter(d -> d.getName().equals(finalUploader)).findFirst().orElseThrow(() -> new FacesException("FileUploaderDecoder '" + finalUploader + "' not found"));
    }

    public static PrimeApplicationContext getCurrentInstance(FacesContext facesContext) {
        return PrimeApplicationContext.getCurrentInstance(facesContext, true);
    }

    public static PrimeApplicationContext getCurrentInstance(FacesContext facesContext, boolean create) {
        if (facesContext == null || facesContext.getExternalContext() == null) {
            return null;
        }
        PrimeApplicationContext applicationContext = (PrimeApplicationContext)facesContext.getExternalContext().getApplicationMap().get(INSTANCE_KEY);
        if (create && applicationContext == null) {
            applicationContext = new PrimeApplicationContext(facesContext);
            PrimeApplicationContext.setCurrentInstance(applicationContext, facesContext);
        }
        return applicationContext;
    }

    public static PrimeApplicationContext getCurrentInstance(ServletContext context) {
        return (PrimeApplicationContext)context.getAttribute(INSTANCE_KEY);
    }

    public static void setCurrentInstance(PrimeApplicationContext context, FacesContext facesContext) {
        facesContext.getExternalContext().getApplicationMap().put(INSTANCE_KEY, context);
        if (facesContext.getExternalContext().getContext() instanceof ServletContext) {
            ((ServletContext)facesContext.getExternalContext().getContext()).setAttribute(INSTANCE_KEY, (Object)context);
        }
    }

    public PrimeEnvironment getEnvironment() {
        return this.environment;
    }

    public PrimeConfiguration getConfig() {
        return this.config;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory == null ? null : this.validatorFactory.get();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider.get();
    }

    public Map<Class<?>, Map<String, Object>> getEnumCacheMap() {
        return this.enumCacheMap;
    }

    public Map<Class<?>, Map<String, Object>> getConstantsCacheMap() {
        return this.constantsCacheMap;
    }

    public Validator getValidator() {
        return this.validator == null ? null : this.validator.get();
    }

    public VirusScannerService getVirusScannerService() {
        return this.virusScannerService.get();
    }

    public FileTypeDetector getFileTypeDetector() {
        return this.fileTypeDetector;
    }

    public void release() {
        if (this.environment != null && this.environment.isAtLeastBv11() && this.validatorFactory != null && this.validatorFactory.isInitialized() && this.validatorFactory.get() != null) {
            this.validatorFactory.get().close();
        }
    }

    public FileUploadDecoder getFileUploadDecoder() {
        return this.fileUploadDecoder;
    }

    public String getFileUploadResumeUrl() {
        return this.fileUploadResumeUrl;
    }

    public Map<Class<? extends UIComponent>, Map<String, Class<? extends Exporter<?>>>> getExporters() {
        return this.exporters;
    }

    public Map<String, ClientValidationConstraint> getBeanValidationClientConstraintMapping() {
        return this.beanValidationClientConstraintMapping;
    }

    public List<MetadataTransformer> getMetadataTransformers() {
        return this.metadataTransformers;
    }
}

