/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import org.primefaces.application.resource.MoveScriptsToBottomResponseWriter;
import org.primefaces.application.resource.MoveScriptsToBottomState;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeExternalContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.csp.CspResponseWriter;
import org.primefaces.csp.CspState;

public class PrimeFacesContext
extends FacesContextWrapper {
    private final FacesContext wrapped;
    private final boolean moveScriptsToBottom;
    private final boolean csp;
    private final boolean markInputAsInvalidOnErrorMsg;
    private MoveScriptsToBottomState moveScriptsToBottomState;
    private CspState cspState;
    private PrimeExternalContext externalContext;

    public PrimeFacesContext(FacesContext wrapped) {
        this.wrapped = wrapped;
        PrimeRequestContext requestContext = new PrimeRequestContext(wrapped);
        PrimeRequestContext.setCurrentInstance(requestContext, wrapped);
        PrimeConfiguration config = requestContext.getApplicationContext().getConfig();
        this.moveScriptsToBottom = config.isMoveScriptsToBottom();
        if (this.moveScriptsToBottom) {
            this.moveScriptsToBottomState = new MoveScriptsToBottomState();
        }
        this.csp = config.isCsp();
        if (this.csp) {
            this.cspState = PrimeFacesContext.getCspState((FacesContext)this);
        }
        this.markInputAsInvalidOnErrorMsg = config.isMarkInputAsInvalidOnErrorMsg();
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public ExternalContext getExternalContext() {
        if (this.externalContext == null) {
            this.externalContext = new PrimeExternalContext(this.wrapped.getExternalContext());
        }
        return this.externalContext;
    }

    public void setResponseWriter(ResponseWriter writer) {
        boolean alreadyWrapped = false;
        ResponseWriter wrappedWriter = writer;
        while (wrappedWriter != null && wrappedWriter instanceof ResponseWriterWrapper) {
            if (wrappedWriter instanceof MoveScriptsToBottomResponseWriter || wrappedWriter instanceof CspResponseWriter) {
                alreadyWrapped = true;
                break;
            }
            wrappedWriter = ((ResponseWriterWrapper)wrappedWriter).getWrapped();
        }
        if (!alreadyWrapped) {
            if (this.csp && !this.getPartialViewContext().isAjaxRequest()) {
                writer = new CspResponseWriter((ResponseWriter)writer, this.cspState);
            }
            if (this.moveScriptsToBottom && !this.getPartialViewContext().isAjaxRequest()) {
                writer = new MoveScriptsToBottomResponseWriter((ResponseWriter)writer, this.moveScriptsToBottomState);
            }
        }
        this.getWrapped().setResponseWriter(writer);
    }

    public FacesContext getWrapped() {
        return this.wrapped;
    }

    public void release() {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(this.wrapped);
        if (requestContext != null) {
            requestContext.release();
        }
        super.release();
        FacesContext.setCurrentInstance(null);
    }

    public void addMessage(String clientId, FacesMessage message) {
        super.addMessage(clientId, message);
        if (this.markInputAsInvalidOnErrorMsg && clientId != null && message != null && FacesMessage.SEVERITY_ERROR.equals(message.getSeverity())) {
            this.getViewRoot().invokeOnComponent((FacesContext)this, clientId, (context, target) -> {
                if (target instanceof UIInput) {
                    ((UIInput)target).setValid(false);
                }
            });
        }
    }

    public static CspState getCspState(FacesContext context) {
        CspState cspState = (CspState)context.getAttributes().get(CspState.class.getName());
        if (cspState == null) {
            cspState = new CspState(context);
            context.getAttributes().put(CspState.class.getName(), cspState);
        }
        return cspState;
    }
}

