/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.PartialViewContextWrapper;
import jakarta.faces.event.PhaseId;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.context.PrimePartialResponseWriter;
import org.primefaces.csp.CspPartialResponseWriter;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.visit.ResetInputContextCallback;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimePartialViewContext
extends PartialViewContextWrapper {
    private PartialViewContext wrapped;
    private PartialResponseWriter writer;

    public PrimePartialViewContext(PartialViewContext wrapped) {
        this.wrapped = wrapped;
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.resetValues(context);
        }
        this.getWrapped().processPartial(phaseId);
    }

    public void setPartialRequest(boolean value) {
        this.getWrapped().setPartialRequest(value);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            PartialResponseWriter parentWriter = this.getWrapped().getPartialResponseWriter();
            this.writer = new PrimePartialResponseWriter(parentWriter);
            FacesContext context = FacesContext.getCurrentInstance();
            PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
            if (config.isCsp()) {
                this.writer = new CspPartialResponseWriter(this.writer, context, PrimeFacesContext.getCspState(context));
            }
        }
        return this.writer;
    }

    public boolean isAjaxRequest() {
        return this.getWrapped().isAjaxRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.partial.ajax");
    }

    public boolean isPartialRequest() {
        return this.getWrapped().isPartialRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.partial.execute");
    }

    private void resetValues(FacesContext context) {
        boolean resetValues;
        Object resetValuesObject = context.getExternalContext().getRequestParameterMap().get("primefaces.resetvalues");
        boolean bl = resetValues = null != resetValuesObject && "true".equals(resetValuesObject);
        if (resetValues) {
            VisitContext visitContext = null;
            ResetInputContextCallback contextCallback = null;
            for (String renderId : context.getPartialViewContext().getRenderIds()) {
                if (LangUtils.isBlank(renderId) || renderId.trim().equals("@none")) continue;
                if (visitContext == null) {
                    visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                }
                if (renderId.equals("@all")) {
                    context.getViewRoot().visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                    continue;
                }
                if (contextCallback == null) {
                    contextCallback = new ResetInputContextCallback(visitContext);
                }
                context.getViewRoot().invokeOnComponent(context, renderId, (ContextCallback)contextCallback);
            }
        }
    }
}

