/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import java.util.PrimitiveIterator;
import org.primefaces.util.LangUtils;

public class JQueryDateTimePatternBuilder {
    private static final boolean[] NEEDS_QUOTE = new boolean[256];
    private final StringBuilder sb = new StringBuilder();

    public JQueryDateTimePatternBuilder appendAmPmHourNoLeadingZeros() {
        this.sb.append("h");
        return this;
    }

    public JQueryDateTimePatternBuilder appendAmPmHourWithLeadingZeros() {
        this.sb.append("hh");
        return this;
    }

    public JQueryDateTimePatternBuilder appendAmPmLongLowercase() {
        this.sb.append("tt");
        return this;
    }

    public JQueryDateTimePatternBuilder appendAmPmLongUppercase() {
        this.sb.append("TT");
        return this;
    }

    public JQueryDateTimePatternBuilder appendAmPmShortLowercase() {
        this.sb.append("t");
        return this;
    }

    public JQueryDateTimePatternBuilder appendAmPmShortUppercase() {
        this.sb.append("T");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayNameLong() {
        this.sb.append("DD");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayNameShort() {
        this.sb.append("D");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayOfMonthNoLeadingZeros() {
        this.sb.append("d");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayOfMonthWithLeadingZeros() {
        this.sb.append("dd");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayOfYearNoLeadingZeros() {
        this.sb.append("o");
        return this;
    }

    public JQueryDateTimePatternBuilder appendDayOfYearWithLeadingZeros() {
        this.sb.append("oo");
        return this;
    }

    public JQueryDateTimePatternBuilder appendHourNoLeadingZeros() {
        this.sb.append("H");
        return this;
    }

    public JQueryDateTimePatternBuilder appendHourWithLeadingZeros() {
        this.sb.append("HH");
        return this;
    }

    public JQueryDateTimePatternBuilder appendLiteralText(String text) {
        if (!LangUtils.isEmpty(text)) {
            if (this.isQuoteNeeded(text)) {
                this.sb.append('\'');
                this.appendEscapedLiteralText(text);
                this.sb.append('\'');
            } else {
                this.appendEscapedLiteralText(text);
            }
        }
        return this;
    }

    public JQueryDateTimePatternBuilder appendMicrosecondsWithLeadingZeros() {
        this.sb.append("c");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMillisecondsWithLeadingZeros() {
        this.sb.append("l");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMinuteNoLeadingZeros() {
        this.sb.append("m");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMinuteWithLeadingZeros() {
        this.sb.append("mm");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMonthNameLong() {
        this.sb.append("MM");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMonthNameShort() {
        this.sb.append("M");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMonthOfYearNoLeadingZeros() {
        this.sb.append("m");
        return this;
    }

    public JQueryDateTimePatternBuilder appendMonthOfYearWithLeadingZeros() {
        this.sb.append("mm");
        return this;
    }

    public JQueryDateTimePatternBuilder appendSecondNoLeadingZeros() {
        this.sb.append("s");
        return this;
    }

    public JQueryDateTimePatternBuilder appendSecondWithLeadingZeros() {
        this.sb.append("ss");
        return this;
    }

    public JQueryDateTimePatternBuilder appendTimezoneByProvidedTimezoneList() {
        this.sb.append("z");
        return this;
    }

    public JQueryDateTimePatternBuilder appendTimezoneIso8601() {
        this.sb.append("Z");
        return this;
    }

    public JQueryDateTimePatternBuilder appendUnixTimestamp() {
        this.sb.append("@");
        return this;
    }

    public JQueryDateTimePatternBuilder appendWindowsTicks() {
        this.sb.append("!");
        return this;
    }

    public JQueryDateTimePatternBuilder appendYearFourDigits() {
        this.sb.append("yy");
        return this;
    }

    public JQueryDateTimePatternBuilder appendYearTwoDigits() {
        this.sb.append("y");
        return this;
    }

    public StringBuilder getStringBuilder() {
        return this.sb;
    }

    public String toString() {
        return this.sb.toString();
    }

    private void appendEscapedLiteralText(String text) {
        PrimitiveIterator.OfInt it = text.codePoints().iterator();
        while (it.hasNext()) {
            int ch = it.nextInt();
            if (ch == 39) {
                this.sb.append("''");
                continue;
            }
            this.sb.appendCodePoint(ch);
        }
    }

    private boolean isQuoteNeeded(String text) {
        PrimitiveIterator.OfInt it = text.codePoints().iterator();
        while (it.hasNext()) {
            int ch = it.nextInt();
            if (ch < 0 || ch >= 256 || !NEEDS_QUOTE[ch]) continue;
            return true;
        }
        return false;
    }

    static {
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[100] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[111] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[68] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[109] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[77] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[121] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[64] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[33] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[72] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[104] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[109] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[115] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[108] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[99] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[116] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[84] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[122] = true;
        JQueryDateTimePatternBuilder.NEEDS_QUOTE[90] = true;
    }
}

