/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.context.FacesContext;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.expression.ClientIdSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.expression.impl.WidgetVarVisitCallback;

public class WidgetVarExpressionResolver
implements SearchExpressionResolver,
ClientIdSearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@widgetVar\\((\\w+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        try {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(matcher.group(1));
                context.getViewRoot().visitTree(SearchExpressionUtils.createVisitContext(context, hints), (VisitCallback)visitCallback);
                return visitCallback.getComponent();
            }
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + expression + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + expression + "\"", (Throwable)e);
        }
    }

    @Override
    public String resolveClientIds(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        return expression;
    }
}

