/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;
import org.primefaces.util.LangUtils;

public class DefaultScheduleModel
implements ScheduleModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<ScheduleEvent<?>> events;
    private boolean eventLimit;

    public DefaultScheduleModel() {
        this.events = new ArrayList();
    }

    public DefaultScheduleModel(List<ScheduleEvent<?>> events) {
        this.events = events;
    }

    @Override
    public void addEvent(ScheduleEvent<?> event) {
        if (LangUtils.isEmpty(event.getId())) {
            event.setId(UUID.randomUUID().toString());
        }
        this.events.add(event);
    }

    @Override
    public boolean deleteEvent(ScheduleEvent<?> event) {
        return this.events.remove(event);
    }

    @Override
    public List<ScheduleEvent<?>> getEvents() {
        return this.events;
    }

    @Override
    public ScheduleEvent<?> getEvent(String id) {
        for (ScheduleEvent<?> event : this.events) {
            if (!event.getId().equals(id)) continue;
            return event;
        }
        return null;
    }

    @Override
    public void updateEvent(ScheduleEvent<?> event) {
        int index = -1;
        for (int i = 0; i < this.events.size(); ++i) {
            if (!this.events.get(i).getId().equals(event.getId())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.events.set(index, event);
        }
    }

    @Override
    public int getEventCount() {
        return this.events.size();
    }

    @Override
    public void clear() {
        this.events = new ArrayList();
    }

    @Override
    public boolean isEventLimit() {
        return this.eventLimit;
    }

    public void setEventLimit(boolean eventLimit) {
        this.eventLimit = eventLimit;
    }
}

