/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.util.FileUploadUtils;

public class CommonsUploadedFile
implements UploadedFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient FileItem fileItem;
    private Long sizeLimit;

    public CommonsUploadedFile() {
    }

    public CommonsUploadedFile(FileItem fileItem, Long sizeLimit) {
        this.fileItem = fileItem;
        this.sizeLimit = sizeLimit;
    }

    @Override
    public String getFileName() {
        return FileUploadUtils.getValidFilename(this.fileItem.getName());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sizeLimit == null ? this.fileItem.getInputStream() : new BoundedInputStream(this.fileItem.getInputStream(), this.sizeLimit);
    }

    @Override
    public long getSize() {
        return this.fileItem.getSize();
    }

    @Override
    public byte[] getContent() {
        return this.fileItem.get();
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public void write(String filePath) throws Exception {
        String validFilePath = FileUploadUtils.getValidFilePath(filePath);
        this.fileItem.write(new File(validFilePath));
    }

    @Override
    public void delete() throws IOException {
        this.fileItem.delete();
    }
}

