/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.filter;

import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Locale;
import org.primefaces.model.filter.ComparableFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;

public class BetweenFilterConstraint
implements FilterConstraint {
    @Override
    public boolean isMatching(FacesContext ctxt, Object value, Object filter, Locale locale) {
        if (filter != null && !(filter instanceof List)) {
            throw new IllegalArgumentException("Filter should be a java.util.List");
        }
        List filterList = (List)filter;
        if (filterList == null || filterList.size() != 2 || value == null) {
            return false;
        }
        ComparableFilterConstraint.assertComparable(value);
        Object start = filterList.get(0);
        Object end = filterList.get(1);
        if (start == null || end == null) {
            return false;
        }
        ComparableFilterConstraint.assertAssignable(end, value);
        return this.isBetween((Comparable)value, (Comparable)start, (Comparable)end);
    }

    protected boolean isBetween(Comparable value, Comparable start, Comparable end) {
        return value.compareTo(start) >= 0 && value.compareTo(end) <= 0;
    }
}

