/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.model.map.Circle;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;
import org.primefaces.model.map.Overlay;
import org.primefaces.model.map.Polygon;
import org.primefaces.model.map.Polyline;
import org.primefaces.model.map.Rectangle;

public class DefaultMapModel<T>
implements MapModel<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DefaultMapModel.class.getName());
    private static final String MARKER_ID_PREFIX = "marker";
    private static final String POLYLINE_ID_PREFIX = "polyline_";
    private static final String POLYGON_ID_PREFIX = "polygon_";
    private static final String CIRCLE_ID_PREFIX = "circle_";
    private static final String RECTANGLE_ID_PREFIX = "rectangle_";
    private List<Marker<T>> markers = new ArrayList<Marker<T>>();
    private List<Polyline<T>> polylines = new ArrayList<Polyline<T>>();
    private List<Polygon<T>> polygons = new ArrayList<Polygon<T>>();
    private List<Circle<T>> circles = new ArrayList<Circle<T>>();
    private List<Rectangle<T>> rectangles = new ArrayList<Rectangle<T>>();

    @Override
    public List<Marker<T>> getMarkers() {
        return this.markers;
    }

    @Override
    public List<Polyline<T>> getPolylines() {
        return this.polylines;
    }

    @Override
    public List<Polygon<T>> getPolygons() {
        return this.polygons;
    }

    @Override
    public List<Circle<T>> getCircles() {
        return this.circles;
    }

    @Override
    public List<Rectangle<T>> getRectangles() {
        return this.rectangles;
    }

    @Override
    public void addOverlay(Overlay<T> overlay) {
        if (overlay.getId() != null) {
            LOGGER.log(Level.WARNING, "Overlays should not have a set ID. It will be overwritten.");
        }
        if (overlay instanceof Marker) {
            overlay.setId(MARKER_ID_PREFIX + UUID.randomUUID().toString());
            this.markers.add((Marker)overlay);
        } else if (overlay instanceof Polyline) {
            overlay.setId(POLYLINE_ID_PREFIX + UUID.randomUUID().toString());
            this.polylines.add((Polyline)overlay);
        } else if (overlay instanceof Polygon) {
            overlay.setId(POLYGON_ID_PREFIX + UUID.randomUUID().toString());
            this.polygons.add((Polygon)overlay);
        } else if (overlay instanceof Circle) {
            overlay.setId(CIRCLE_ID_PREFIX + UUID.randomUUID().toString());
            this.circles.add((Circle)overlay);
        } else if (overlay instanceof Rectangle) {
            overlay.setId(RECTANGLE_ID_PREFIX + UUID.randomUUID().toString());
            this.rectangles.add((Rectangle)overlay);
        }
    }

    @Override
    public Overlay<T> findOverlay(String id) {
        List<Object> overlays = Collections.emptyList();
        if (id.startsWith(MARKER_ID_PREFIX)) {
            overlays = this.markers;
        } else if (id.startsWith(POLYLINE_ID_PREFIX)) {
            overlays = this.polylines;
        } else if (id.startsWith(POLYGON_ID_PREFIX)) {
            overlays = this.polygons;
        } else if (id.startsWith(CIRCLE_ID_PREFIX)) {
            overlays = this.circles;
        } else if (id.startsWith(RECTANGLE_ID_PREFIX)) {
            overlays = this.rectangles;
        }
        for (Overlay overlay : overlays) {
            if (!overlay.getId().equals(id)) continue;
            return overlay;
        }
        return null;
    }
}

