/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.seo;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.model.seo.JsonLDItem;
import org.primefaces.model.seo.JsonLDModel;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;

public class JsonLD {
    private JsonLD() {
    }

    public static void encode(FacesContext context, JsonLDModel model, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("type", (Object)"application/ld+json", null);
        JsonLD.encodeModel(context, model);
        writer.endElement("script");
    }

    public static void encodeModel(FacesContext context, JsonLDModel model) throws IOException {
        if (model != null) {
            ResponseWriter writer = context.getResponseWriter();
            try (FastStringWriter fsw = new FastStringWriter();){
                fsw.write("{");
                JsonLD.writeOption(fsw, "@context", model.getContext(), false);
                JsonLD.writeOption(fsw, "@type", model.getType(), true);
                JsonLD.encodeItems(fsw, model.getItemListType(), model.getItems(), true);
                fsw.write("}");
                writer.write(fsw.toString());
            }
        }
    }

    public static void encodeItems(FastStringWriter writer, String optionName, List<JsonLDItem> items, boolean hasComma) throws IOException {
        if (items == null) {
            return;
        }
        if (hasComma) {
            writer.write(",");
        }
        writer.write("\"" + optionName + "\":");
        writer.write("[");
        for (int i = 0; i < items.size(); ++i) {
            JsonLDItem item = items.get(i);
            if (i != 0) {
                writer.write(",");
            }
            JsonLD.encodeItem(writer, item);
        }
        writer.write("]");
    }

    public static void encodeItem(FastStringWriter writer, JsonLDItem item) throws IOException {
        writer.write("{");
        JsonLD.writeOption(writer, "@type", item.getType(), false);
        JsonLD.writeOption(writer, "position", item.getPosition(), true);
        JsonLD.writeOption(writer, "name", item.getName(), true);
        JsonLD.writeOption(writer, "item", item.getItem(), true);
        writer.write("}");
    }

    public static void writeOption(FastStringWriter writer, String name, Object value, boolean hasComma) throws IOException {
        if (value != null && LangUtils.isNotBlank(value.toString())) {
            if (hasComma) {
                writer.write(",");
            }
            writer.write(JSONObject.quote(name) + ":" + JSONObject.valueToString(value));
        }
    }
}

