/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

public class AjaxRequestBuilder {
    private static final Logger LOG = Logger.getLogger(AjaxRequestBuilder.class.getName());
    private static final Set<SearchExpressionHint> HINTS_UPDATE = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.VALIDATE_RENDERER, SearchExpressionHint.SKIP_UNRENDERED, SearchExpressionHint.RESOLVE_CLIENT_SIDE));
    private static final Set<SearchExpressionHint> HINTS_UPDATE_IGNORE_NO_RESULT = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.VALIDATE_RENDERER, SearchExpressionHint.SKIP_UNRENDERED, SearchExpressionHint.RESOLVE_CLIENT_SIDE, SearchExpressionHint.IGNORE_NO_RESULT));
    private static final Set<SearchExpressionHint> HINTS_PROCESS = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE));
    private static final Set<SearchExpressionHint> HINTS_PROCESS_IGNORE_NO_RESULT = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE, SearchExpressionHint.IGNORE_NO_RESULT));
    protected StringBuilder buffer;
    protected FacesContext context;
    private boolean preventDefault;

    public AjaxRequestBuilder(FacesContext context) {
        this.context = context;
        this.buffer = new StringBuilder();
    }

    public AjaxRequestBuilder init() {
        this.buffer.append("PrimeFaces.ab({");
        return this;
    }

    public AjaxRequestBuilder source(String source) {
        if (source != null) {
            this.buffer.append("s:").append("\"").append(source).append("\"");
        } else {
            this.buffer.append("s:").append("this");
        }
        return this;
    }

    public AjaxRequestBuilder form(AjaxSource source, UIComponent component, UIForm formComponent) {
        String result = null;
        String form = source.getForm();
        if (LangUtils.isBlank(form)) {
            if (formComponent == null) {
                formComponent = ComponentTraversalUtils.closestForm(component);
            }
            if (formComponent == null) {
                if (this.context.isProjectStage(ProjectStage.Development)) {
                    String message = "Component '" + component.getClientId(this.context) + "' should be inside a form or should reference a form via its form attribute. We will try to find a fallback form on the client side.";
                    LOG.info(message);
                }
            } else {
                result = formComponent.getClientId(this.context);
            }
        } else {
            result = SearchExpressionFacade.resolveClientId(this.context, component, source.getForm());
        }
        if (result != null) {
            this.buffer.append(",f:\"").append(result).append("\"");
        }
        return this;
    }

    public AjaxRequestBuilder form(AjaxSource source, UIComponent component) {
        return this.form(source, component, null);
    }

    public AjaxRequestBuilder form(String form) {
        if (form != null) {
            this.buffer.append(",f:\"").append(form).append("\"");
        }
        return this;
    }

    public AjaxRequestBuilder process(UIComponent component, String expressions) {
        return this.process(component, expressions, false);
    }

    public AjaxRequestBuilder process(UIComponent component, String expressions, boolean ignoreNoResult) {
        this.addExpressions(component, expressions, "p", ignoreNoResult ? HINTS_PROCESS_IGNORE_NO_RESULT : HINTS_PROCESS);
        return this;
    }

    public AjaxRequestBuilder update(UIComponent component, String expressions) {
        return this.update(component, expressions, false);
    }

    public AjaxRequestBuilder update(UIComponent component, String expressions, boolean ignoreNoResult) {
        this.addExpressions(component, expressions, "u", ignoreNoResult ? HINTS_UPDATE_IGNORE_NO_RESULT : HINTS_UPDATE);
        return this;
    }

    private AjaxRequestBuilder addExpressions(UIComponent component, String expressions, String key, Set<SearchExpressionHint> hints) {
        if (LangUtils.isNotBlank(expressions)) {
            String resolvedExpressions = SearchExpressionFacade.resolveClientIds(this.context, component, expressions, hints);
            this.buffer.append(",").append(key).append(":\"").append(resolvedExpressions).append("\"");
        }
        return this;
    }

    public AjaxRequestBuilder event(String event) {
        this.buffer.append(",e:\"").append(event).append("\"");
        return this;
    }

    public AjaxRequestBuilder async(boolean async) {
        if (async) {
            this.buffer.append(",a:true");
        }
        return this;
    }

    public AjaxRequestBuilder skipChildren(boolean skipChildren) {
        if (!skipChildren) {
            this.buffer.append(",sc:false");
        }
        return this;
    }

    public AjaxRequestBuilder global(boolean global) {
        if (!global) {
            this.buffer.append(",g:false");
        }
        return this;
    }

    public AjaxRequestBuilder delay(String delay) {
        if (LangUtils.isNotBlank(delay) && !"none".equals(delay)) {
            this.buffer.append(",d:").append(delay);
            if (this.context.isProjectStage(ProjectStage.Development)) {
                try {
                    Integer.parseInt(delay);
                }
                catch (NumberFormatException e) {
                    throw new FaceletException("Delay attribute should only take numbers or \"none\"");
                }
            }
        }
        return this;
    }

    public AjaxRequestBuilder timeout(int timeout) {
        if (timeout > 0) {
            this.buffer.append(",t:").append(timeout);
        }
        return this;
    }

    public AjaxRequestBuilder ignoreAutoUpdate(boolean ignoreAutoUpdate) {
        if (ignoreAutoUpdate) {
            this.buffer.append(",iau:true");
        }
        return this;
    }

    public AjaxRequestBuilder partialSubmit(boolean value, boolean partialSubmitSet, String partialSubmitFilter) {
        if (partialSubmitSet) {
            this.buffer.append(",ps:").append(value);
            if (value && partialSubmitFilter != null) {
                this.buffer.append(",psf:\"").append(partialSubmitFilter).append("\"");
            }
        }
        return this;
    }

    public AjaxRequestBuilder resetValues(boolean value, boolean resetValuesSet) {
        boolean resetValues;
        PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(this.context).getConfig();
        boolean bl = resetValues = resetValuesSet ? value : config.isResetValuesEnabled();
        if (resetValues) {
            this.buffer.append(",rv:true");
        }
        return this;
    }

    public AjaxRequestBuilder onstart(String onstart) {
        if (onstart != null) {
            this.buffer.append(",onst:function(cfg){").append(onstart).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onerror(String onerror) {
        if (onerror != null) {
            this.buffer.append(",oner:function(xhr,status,error){").append(onerror).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onsuccess(String onsuccess) {
        if (onsuccess != null) {
            this.buffer.append(",onsu:function(data,status,xhr){").append(onsuccess).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder oncomplete(String oncomplete) {
        if (oncomplete != null) {
            this.buffer.append(",onco:function(xhr,status,args,data){").append(oncomplete).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder params(UIComponent component) {
        boolean paramWritten = false;
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIParameter parameter;
            Object paramValue;
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!(child instanceof UIParameter) || (paramValue = (parameter = (UIParameter)child).getValue()) == null) continue;
            if (!paramWritten) {
                paramWritten = true;
                this.buffer.append(",pa:[");
            } else {
                this.buffer.append(",");
            }
            this.buffer.append("{name:").append("\"").append(EscapeUtils.forJavaScript(parameter.getName())).append("\",value:\"").append(EscapeUtils.forJavaScript(paramValue.toString())).append("\"}");
        }
        if (paramWritten) {
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder params(Map<String, List<String>> params) {
        if (params != null && !params.isEmpty()) {
            this.buffer.append(",pa:[");
            Iterator<Map.Entry<String, List<String>>> it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, List<String>> entry = it.next();
                String name = entry.getKey();
                List<String> paramValues = entry.getValue();
                int size = paramValues.size();
                for (int i = 0; i < size; ++i) {
                    String paramValue = paramValues.get(i);
                    if (paramValue == null) {
                        paramValue = "";
                    }
                    this.buffer.append("{name:").append("\"").append(EscapeUtils.forJavaScript(name)).append("\",value:\"").append(EscapeUtils.forJavaScript(paramValue)).append("\"}");
                    if (i >= size - 1) continue;
                    this.buffer.append(",");
                }
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder passParams() {
        this.buffer.append(",pa:arguments[0]");
        return this;
    }

    public AjaxRequestBuilder preventDefault() {
        this.preventDefault = true;
        return this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String build() {
        this.addFragmentConfig();
        this.buffer.append("});");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public String buildBehavior(ClientBehaviorRenderingMode mode) {
        this.addFragmentConfig();
        if (mode == ClientBehaviorRenderingMode.UNOBSTRUSIVE) {
            this.buffer.append("},ext);");
        } else if (mode == ClientBehaviorRenderingMode.OBSTRUSIVE) {
            this.buffer.append("});");
        }
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public void reset() {
        this.buffer.setLength(0);
        this.preventDefault = false;
    }

    private void addFragmentConfig() {
        Object fragmentUpdate;
        Map attrs = this.context.getAttributes();
        Object fragmentProcess = attrs.get("primefaces.fragment.process");
        if (fragmentProcess != null) {
            this.buffer.append(",fp:\"").append(fragmentProcess).append("\"");
        }
        if ((fragmentUpdate = attrs.get("primefaces.fragment.update")) != null) {
            this.buffer.append(",fu:\"").append(fragmentUpdate).append("\"");
        }
    }
}

