/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.FacesException;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.EditableValueHolderAttachedObjectTarget;
import java.beans.BeanInfo;
import java.util.List;

public class CompositeUtils {
    private CompositeUtils() {
    }

    public static boolean isComposite(UIComponent component) {
        return UIComponent.isCompositeComponent((UIComponent)component);
    }

    public static void invokeOnDeepestEditableValueHolder(FacesContext context, UIComponent composite, final ContextCallback callback) {
        if (composite instanceof EditableValueHolder) {
            callback.invokeContextCallback(context, composite);
            return;
        }
        BeanInfo info = (BeanInfo)composite.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        List targets = (List)info.getBeanDescriptor().getValue("jakarta.faces.view.AttachedObjectTargets");
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                AttachedObjectTarget target = (AttachedObjectTarget)targets.get(i);
                if (!(target instanceof EditableValueHolderAttachedObjectTarget)) continue;
                List childs = target.getTargets(composite);
                if (childs == null || childs.isEmpty()) {
                    throw new FacesException("Cannot not resolve editableValueHolder target in composite component with id: \"" + composite.getClientId() + "\"");
                }
                if (childs.size() > 1) {
                    throw new FacesException("Only a single editableValueHolder target is supported in composite component with id: \"" + composite.getClientId() + "\"");
                }
                final UIComponent child = (UIComponent)childs.get(0);
                composite.invokeOnComponent(context, composite.getClientId(context), new ContextCallback(){

                    public void invokeContextCallback(FacesContext context, UIComponent target) {
                        if (CompositeUtils.isComposite(child)) {
                            CompositeUtils.invokeOnDeepestEditableValueHolder(context, child, callback);
                        } else {
                            callback.invokeContextCallback(context, child);
                        }
                    }
                });
            }
        }
    }
}

