/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.ELUtils;
import org.primefaces.util.Lazy;
import org.primefaces.util.LimitedSizeHashMap;
import org.primefaces.util.ResourceUtils;
import org.primefaces.util.SharedStringBuilder;

public class DynamicContentSrcBuilder {
    private static final String SB_BUILD_STREAMING = DynamicContentSrcBuilder.class.getName() + "#buildStreaming";

    private DynamicContentSrcBuilder() {
    }

    public static String build(FacesContext context, UIComponent component, ValueExpression ve, Lazy<Object> value, boolean cache, boolean stream) {
        Class<?> type = ELUtils.getType(context, ve, value);
        if (type == null) {
            return "";
        }
        if (String.class.isAssignableFrom(type)) {
            String src = ResourceUtils.getResourceURL(context, (String)value.get());
            return ResourceUtils.encodeResourceURL(context, src, cache);
        }
        if (StreamedContent.class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            StreamedContent streamedContent = (StreamedContent)value.get();
            if (streamedContent.getWriter() != null) {
                return ResourceUtils.toBase64(context, streamedContent.getWriter(), streamedContent.getContentType());
            }
            return ResourceUtils.toBase64(context, streamedContent.getStream().get(), streamedContent.getContentType());
        }
        if (byte[].class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            return ResourceUtils.toBase64(context, (byte[])value.get());
        }
        if (InputStream.class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            return ResourceUtils.toBase64(context, (InputStream)value.get());
        }
        return "";
    }

    public static String buildStreaming(FacesContext context, UIComponent component, ValueExpression valueExpression, boolean cache) {
        Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", "text/plain");
        String resourcePath = resource.getRequestPath();
        Map session = context.getExternalContext().getSessionMap();
        LimitedSizeHashMap<String, String> dynamicResourcesMapping = (LimitedSizeHashMap<String, String>)session.get("primefaces.dynamicResourcesMapping");
        if (dynamicResourcesMapping == null) {
            dynamicResourcesMapping = new LimitedSizeHashMap<String, String>(200);
            session.put("primefaces.dynamicResourcesMapping", dynamicResourcesMapping);
        }
        String expressionString = valueExpression.getExpressionString();
        String resourceKey = DynamicContentSrcBuilder.md5(expressionString);
        dynamicResourcesMapping.put(resourceKey, expressionString);
        try {
            StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD_STREAMING);
            builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(resourceKey, "UTF-8")).append("&").append("pfdrt").append("=").append(DynamicContentType.STREAMED_CONTENT.toString());
            if (component != null) {
                for (int i = 0; i < component.getChildCount(); ++i) {
                    UIParameter param;
                    UIComponent child = (UIComponent)component.getChildren().get(i);
                    if (!(child instanceof UIParameter) || (param = (UIParameter)child).isDisable()) continue;
                    Object paramValue = param.getValue();
                    builder.append("&").append(param.getName()).append("=");
                    if (paramValue == null) continue;
                    builder.append(URLEncoder.encode(paramValue.toString(), "UTF-8"));
                }
            }
            return ResourceUtils.encodeResourceURL(context, builder.toString(), cache);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    protected static String md5(String input) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FacesException((Throwable)ex);
        }
        byte[] bytes = messageDigest.digest(input.getBytes());
        return new BigInteger(1, bytes).toString(16);
    }
}

