/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.context.FacesContext;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class StyleBuilder {
    private static final String KEY = StyleBuilder.class.getName() + "#style";
    private final StringBuilder sb;

    public StyleBuilder(FacesContext context) {
        this.sb = SharedStringBuilder.get(context, KEY);
    }

    public StyleBuilder add(String style) {
        this.add(LangUtils.isNotBlank(style), style);
        return this;
    }

    public StyleBuilder add(String attribute, String value) {
        this.add(LangUtils.isNotBlank(value), attribute, value);
        return this;
    }

    public StyleBuilder add(boolean condition, String style) {
        if (condition) {
            if (this.sb.length() != 0) {
                this.sb.append(";");
            }
            this.sb.append(style);
        }
        return this;
    }

    public StyleBuilder add(boolean condition, String attribute, String value) {
        if (condition) {
            if (this.sb.length() != 0) {
                this.sb.append(";");
            }
            this.sb.append(attribute).append(":").append(value);
        }
        return this;
    }

    public StyleBuilder add(boolean condition, String attribute, String trueValue, String falseValue) {
        if (condition) {
            this.add(attribute, trueValue);
        } else {
            this.add(attribute, falseValue);
        }
        return this;
    }

    public String build() {
        String style = this.sb.toString();
        this.sb.setLength(0);
        return style;
    }
}

