/*
 * The MIT License
 *
 * Copyright (c) 2009-2023 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.component.panelgrid;

import javax.faces.component.UIPanel;


public abstract class PanelGridBase extends UIPanel {

    public static final String COMPONENT_FAMILY = "org.primefaces.component";

    public static final String DEFAULT_RENDERER = "org.primefaces.component.PanelGridRenderer";

    public static final String LAYOUT_TABULAR = "tabular";
    public static final String LAYOUT_GRID = "grid";
    public static final String LAYOUT_FLEX = "flex";

    public enum PropertyKeys {

        columns,
        style,
        contentStyle,
        styleClass,
        contentStyleClass,
        columnClasses,
        layout,
        role
    }

    public PanelGridBase() {
        setRendererType(DEFAULT_RENDERER);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getColumns() {
        return (Integer) getStateHelper().eval(PropertyKeys.columns, 12);
    }

    public void setColumns(int columns) {
        getStateHelper().put(PropertyKeys.columns, columns);
    }

    public String getStyle() {
        return (String) getStateHelper().eval(PropertyKeys.style, null);
    }

    public void setStyle(String style) {
        getStateHelper().put(PropertyKeys.style, style);
    }

    public String getContentStyle() {
        return (String) getStateHelper().eval(PropertyKeys.contentStyle, null);
    }

    public void setContentStyle(String contentStyle) {
        getStateHelper().put(PropertyKeys.contentStyle, contentStyle);
    }

    public String getStyleClass() {
        return (String) getStateHelper().eval(PropertyKeys.styleClass, null);
    }

    public void setStyleClass(String styleClass) {
        getStateHelper().put(PropertyKeys.styleClass, styleClass);
    }

    public String getContentStyleClass() {
        return (String) getStateHelper().eval(PropertyKeys.contentStyleClass, null);
    }

    public void setContentStyleClass(String contentStyleClass) {
        getStateHelper().put(PropertyKeys.contentStyleClass, contentStyleClass);
    }

    public String getColumnClasses() {
        return (String) getStateHelper().eval(PropertyKeys.columnClasses, null);
    }

    public void setColumnClasses(String columnClasses) {
        getStateHelper().put(PropertyKeys.columnClasses, columnClasses);
    }

    public String getLayout() {
        return (String) getStateHelper().eval(PropertyKeys.layout, LAYOUT_GRID);
    }

    public void setLayout(String layout) {
        getStateHelper().put(PropertyKeys.layout, layout);
    }

    public String getRole() {
        return (String) getStateHelper().eval(PropertyKeys.role, "grid");
    }

    public void setRole(String role) {
        getStateHelper().put(PropertyKeys.role, role);
    }

}