/*
 * The MIT License
 *
 * Copyright (c) 2009-2023 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.model.charts.axes.radial.linear;

import java.io.IOException;
import java.io.Serializable;

import org.primefaces.util.ChartUtils;
import org.primefaces.util.FastStringWriter;

/**
 * Used to configure angled lines that radiate from the center of the chart to the point labels.
 */
public class RadialLinearAngleLines implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean display = true;
    private String color;
    private Number lineWidth;

    /**
     * Gets the display
     *
     * @return display
     */
    public boolean isDisplay() {
        return display;
    }

    /**
     * Sets the display
     *
     * @param display if true, angle lines are shown
     */
    public void setDisplay(boolean display) {
        this.display = display;
    }

    /**
     * Gets the color
     *
     * @return color
     */
    public String getColor() {
        return color;
    }

    /**
     * Sets the color
     *
     * @param color Color of angled lines
     */
    public void setColor(String color) {
        this.color = color;
    }

    /**
     * Gets the lineWidth
     *
     * @return lineWidth
     */
    public Number getLineWidth() {
        return lineWidth;
    }

    /**
     * Sets the lineWidth
     *
     * @param lineWidth Width of angled lines
     */
    public void setLineWidth(Number lineWidth) {
        this.lineWidth = lineWidth;
    }

    /**
     * Write the options of angled lines on radial linear type
     *
     * @return options as JSON object
     * @throws java.io.IOException If an I/O error occurs
     */
    public String encode() throws IOException {
        try (FastStringWriter fsw = new FastStringWriter()) {
            fsw.write("{");

            ChartUtils.writeDataValue(fsw, "display", this.display, false);
            ChartUtils.writeDataValue(fsw, "color", this.color, true);
            ChartUtils.writeDataValue(fsw, "lineWidth", this.lineWidth, true);

            fsw.write("}");

            return fsw.toString();
        }
    }
}
