/*
 * The MIT License
 *
 * Copyright (c) 2009-2023 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.component.inputmask;

import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.api.Widget;

public abstract class InputMaskBase extends AbstractPrimeHtmlInputText implements Widget {

    public static final String COMPONENT_FAMILY = "org.primefaces.component";

    public static final String DEFAULT_RENDERER = "org.primefaces.component.InputMaskRenderer";

    public enum PropertyKeys {

        placeholder,
        widgetVar,
        mask,
        slotChar,
        autoClear,
        type,
        validateMask,
        showMaskOnFocus,
        showMaskOnHover
    }

    public InputMaskBase() {
        setRendererType(DEFAULT_RENDERER);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPlaceholder() {
        return (String) getStateHelper().eval(PropertyKeys.placeholder, null);
    }

    public void setPlaceholder(String placeholder) {
        getStateHelper().put(PropertyKeys.placeholder, placeholder);
    }

    public String getWidgetVar() {
        return (String) getStateHelper().eval(PropertyKeys.widgetVar, null);
    }

    public void setWidgetVar(String widgetVar) {
        getStateHelper().put(PropertyKeys.widgetVar, widgetVar);
    }

    public String getMask() {
        return (String) getStateHelper().eval(PropertyKeys.mask, null);
    }

    public void setMask(String mask) {
        getStateHelper().put(PropertyKeys.mask, mask);
    }

    public String getSlotChar() {
        return (String) getStateHelper().eval(PropertyKeys.slotChar, "_");
    }

    public void setSlotChar(String slotChar) {
        getStateHelper().put(PropertyKeys.slotChar, slotChar);
    }

    public boolean isAutoClear() {
        return (Boolean) getStateHelper().eval(PropertyKeys.autoClear, true);
    }

    public void setAutoClear(boolean autoClear) {
        getStateHelper().put(PropertyKeys.autoClear, autoClear);
    }

    public String getType() {
        return (String) getStateHelper().eval(PropertyKeys.type, "text");
    }

    public void setType(String type) {
        getStateHelper().put(PropertyKeys.type, type);
    }

    public boolean isValidateMask() {
        return (Boolean) getStateHelper().eval(PropertyKeys.validateMask, true);
    }

    public void setValidateMask(boolean validateMask) {
        getStateHelper().put(PropertyKeys.validateMask, validateMask);
    }

    public boolean isShowMaskOnFocus() {
        return (Boolean) getStateHelper().eval(PropertyKeys.showMaskOnFocus, true);
    }

    public void setShowMaskOnFocus(boolean showMaskOnFocus) {
        getStateHelper().put(PropertyKeys.showMaskOnFocus, showMaskOnFocus);
    }

    public boolean isShowMaskOnHover() {
        return (Boolean) getStateHelper().eval(PropertyKeys.showMaskOnHover, true);
    }

    public void setShowMaskOnHover(boolean showMaskOnHover) {
        getStateHelper().put(PropertyKeys.showMaskOnHover, showMaskOnHover);
    }
}