/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autoupdate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import org.primefaces.util.LangUtils;

public class AutoUpdateListener
implements ComponentSystemEventListener {
    private static final String COMPONENT_CLIENT_IDS = AutoUpdateListener.class.getName() + ".COMPONENT_CLIENT_IDS";
    private static final AutoUpdateListener INSTANCE = new AutoUpdateListener();
    private ValueExpression disabled;
    private String on;

    public AutoUpdateListener() {
    }

    public AutoUpdateListener(ValueExpression disabled) {
        this();
        this.disabled = disabled;
    }

    public AutoUpdateListener(String on) {
        this();
        this.on = on;
    }

    public AutoUpdateListener(ValueExpression disabled, String on) {
        this();
        this.disabled = disabled;
        this.on = on;
    }

    public void processEvent(ComponentSystemEvent cse) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = ((UIComponent)cse.getSource()).getClientId(context);
        Map<String, List<String>> infos = AutoUpdateListener.getOrCreateAutoUpdateComponentInfos(context);
        if (this.disabled == null || !((Boolean)this.disabled.getValue(context.getELContext())).booleanValue()) {
            if (!infos.containsKey(clientId)) {
                if (this.on == null) {
                    infos.put(clientId, null);
                } else {
                    String[] onList = context.getApplication().getSearchExpressionHandler().splitExpressions(context, this.on);
                    infos.put(clientId, Arrays.asList(onList));
                }
            }
        } else {
            infos.remove(clientId);
        }
    }

    public static Map<String, List<String>> getOrCreateAutoUpdateComponentInfos(FacesContext context) {
        Map<String, List<String>> infos = AutoUpdateListener.getAutoUpdateComponentInfos(context);
        if (infos == null) {
            infos = new HashMap<String, List<String>>();
            context.getViewRoot().getAttributes().put(COMPONENT_CLIENT_IDS, infos);
        }
        return infos;
    }

    public static Map<String, List<String>> getAutoUpdateComponentInfos(FacesContext context) {
        return (Map)context.getViewRoot().getAttributes().get(COMPONENT_CLIENT_IDS);
    }

    public static void subscribe(UIComponent component) {
        AutoUpdateListener.subscribe(component, INSTANCE);
    }

    public static void subscribe(UIComponent component, String on) {
        if (LangUtils.isBlank(on)) {
            AutoUpdateListener.subscribe(component, INSTANCE);
        } else {
            AutoUpdateListener.subscribe(component, new AutoUpdateListener(on));
        }
    }

    public static void subscribe(UIComponent component, ValueExpression disabled) {
        AutoUpdateListener listener = new AutoUpdateListener(disabled);
        AutoUpdateListener.subscribe(component, listener);
    }

    public static void subscribe(UIComponent component, ValueExpression disabled, String on) {
        AutoUpdateListener listener = new AutoUpdateListener(disabled, on);
        AutoUpdateListener.subscribe(component, listener);
    }

    protected static void subscribe(UIComponent component, ComponentSystemEventListener listener) {
        component.subscribeToEvent(PostAddToViewEvent.class, listener);
        component.subscribeToEvent(PreRenderComponentEvent.class, listener);
    }
}

