/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentRange {
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+|\\*)$");
    private long chunkRangeBegin;
    private long chunkRangeEnd;
    private long chunkTotalFileSize;
    private boolean lastChunk;
    private long packet;

    private ContentRange(long chunkRangeBegin, long chunkRangeEnd, long chunkTotalFileSize, long chunkSize) {
        this.chunkRangeBegin = chunkRangeBegin;
        this.chunkRangeEnd = chunkRangeEnd;
        this.chunkTotalFileSize = chunkTotalFileSize;
        this.lastChunk = chunkRangeEnd + 1L == chunkTotalFileSize;
        this.packet = chunkRangeBegin / chunkSize;
    }

    public static final ContentRange of(String contentRange, long chunkSize) {
        Matcher matcher = CONTENT_RANGE_PATTERN.matcher(contentRange);
        if (matcher.find()) {
            return new ContentRange(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)), chunkSize);
        }
        throw new IllegalArgumentException("Content-Range does not follow pattern: " + CONTENT_RANGE_PATTERN.pattern());
    }

    public long getChunkRangeBegin() {
        return this.chunkRangeBegin;
    }

    public long getChunkRangeEnd() {
        return this.chunkRangeEnd;
    }

    public long getChunkTotalFileSize() {
        return this.chunkTotalFileSize;
    }

    public boolean isLastChunk() {
        return this.lastChunk;
    }

    public long getPacket() {
        return this.packet;
    }
}

