/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputmask;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputmask.InputMask;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class InputMaskRenderer
extends InputRenderer {
    private static final String REGEX_METACHARS = "<([{\\^-=$!|]})?*+.>";
    private static final String SB_PATTERN = InputMaskRenderer.class.getName() + "#translateMaskIntoRegex";

    public void decode(FacesContext context, UIComponent component) {
        InputMask inputMask = (InputMask)component;
        if (!this.shouldDecode((UIInput)inputMask)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputMask);
        String clientId = inputMask.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            Pattern pattern;
            submittedValue = submittedValue.replace(inputMask.getSlotChar(), "");
            String mask = inputMask.getMask();
            if (inputMask.isValidateMask() && !LangUtils.isEmpty(submittedValue) && LangUtils.isNotBlank(mask) && !(pattern = this.translateMaskIntoRegex(context, mask)).matcher(submittedValue).matches()) {
                submittedValue = "";
            }
            inputMask.setSubmittedValue(submittedValue);
        }
    }

    protected Pattern translateMaskIntoRegex(FacesContext context, String mask) {
        StringBuilder regex = SharedStringBuilder.get(context, SB_PATTERN);
        return this.translateMaskIntoRegex(regex, mask);
    }

    protected Pattern translateMaskIntoRegex(StringBuilder regex, String mask) {
        boolean optionalFound = false;
        for (char c : mask.toCharArray()) {
            if (c == '[' || c == ']') {
                optionalFound = true;
                continue;
            }
            regex.append(this.translateMaskCharIntoRegex(c, optionalFound));
        }
        return Pattern.compile(regex.toString());
    }

    protected String translateMaskCharIntoRegex(char c, boolean optional) {
        if (c == '[' || c == ']') {
            return "";
        }
        Object translated = c == '9' ? "[0-9]" : (c == 'a' ? "[A-Za-z]" : (c == 'A' ? "[A-Z]" : (c == '*' ? "[A-Za-z0-9]" : (REGEX_METACHARS.indexOf(c) >= 0 ? "\\" + c : String.valueOf(c)))));
        return optional ? (String)translated + "?" : translated;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputMask inputMask = (InputMask)component;
        this.encodeMarkup(context, inputMask);
        this.encodeScript(context, inputMask);
    }

    protected void encodeScript(FacesContext context, InputMask inputMask) throws IOException {
        String mask = inputMask.getMask();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputMask", inputMask);
        if (mask != null) {
            boolean autoClear = inputMask.isAutoClear();
            if (mask.contains("[") || mask.contains("]")) {
                autoClear = false;
            }
            wb.attr("mask", mask).attr("placeholder", inputMask.getSlotChar(), "_").attr("autoClear", autoClear, true).attr("showMaskOnFocus", inputMask.isShowMaskOnFocus(), true).attr("showMaskOnHover", inputMask.isShowMaskOnHover(), true);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputMask inputMask) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputMask.getClientId(context);
        String styleClass = this.createStyleClass((UIInput)inputMask, "ui-inputfield ui-inputmask ui-widget ui-state-default ui-corner-all");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)inputMask.getType(), "text");
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputMask);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)inputMask);
        this.renderPassThruAttributes(context, (UIComponent)inputMask, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputMask, HTML.INPUT_TEXT_EVENTS);
        if (inputMask.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputMask.getStyle(), "style");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.renderValidationMetadata(context, (EditableValueHolder)inputMask, new ClientValidator[0]);
        writer.endElement("input");
    }
}

