/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.OverlayMenu;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.model.menu.Submenu;
import org.primefaces.renderkit.MenuItemAwareRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public abstract class BaseMenuRenderer
extends MenuItemAwareRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        MenuModel model = menu.getModel();
        if (model != null && menu.getElementsCount() > 0) {
            model.generateUniqueIds();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected String getLinkStyleClass(MenuItem menuItem) {
        String styleClass = menuItem.getStyleClass();
        return styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        this.encodeMenuItem(context, menu, menuitem, "-1");
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem, String tabindex) throws IOException {
        this.encodeMenuItem(context, menu, menuitem, tabindex, new AbstractMap.SimpleEntry<String, String>("role", "menuitem"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem, String tabindex, Map.Entry<String, String> aria) throws IOException {
        boolean isMenuItemComponent = menuitem instanceof UIComponent;
        try {
            if (isMenuItemComponent) {
                UIComponent uiMenuItem = (UIComponent)menuitem;
                uiMenuItem.pushComponentToEL(context, uiMenuItem);
                UIComponent custom = uiMenuItem.getFacet("custom");
                if (FacetUtils.shouldRenderFacet(custom)) {
                    custom.encodeAll(context);
                    return;
                }
            }
            ResponseWriter writer = context.getResponseWriter();
            String title = menuitem.getTitle();
            String style = menuitem.getStyle();
            boolean disabled = menuitem.isDisabled();
            String rel = menuitem.getRel();
            String ariaLabel = menuitem.getAriaLabel();
            writer.startElement("a", null);
            writer.writeAttribute("tabindex", (Object)tabindex, null);
            if (aria != null) {
                writer.writeAttribute(aria.getKey(), (Object)aria.getValue(), null);
            }
            if (this.shouldRenderId(menuitem)) {
                writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
            }
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            Object styleClass = this.getLinkStyleClass(menuitem);
            if (disabled) {
                styleClass = (String)styleClass + " ui-state-disabled";
            }
            writer.writeAttribute("class", styleClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (rel != null) {
                writer.writeAttribute("rel", (Object)rel, null);
            }
            if (LangUtils.isNotEmpty(ariaLabel)) {
                writer.writeAttribute("aria-label", (Object)ariaLabel, null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                this.encodeOnClick(context, (UIComponent)menu, menuitem);
            }
            if (isMenuItemComponent) {
                this.renderPassThruAttributes(context, (UIComponent)menuitem, new List[0]);
            }
            this.encodeMenuItemContent(context, menu, menuitem);
            writer.endElement("a");
        }
        finally {
            if (isMenuItemComponent) {
                UIComponent uiMenuItem = (UIComponent)menuitem;
                uiMenuItem.popComponentFromEL(context);
            }
        }
    }

    protected boolean shouldRenderId(MenuElement element) {
        if (element instanceof UIComponent) {
            UIComponent component = (UIComponent)element;
            return component.getParent() instanceof MenuButton || this.shouldWriteId(component);
        }
        return false;
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        String iconPos;
        ResponseWriter writer = context.getResponseWriter();
        Object value = menuitem.getValue();
        boolean isRtl = ComponentUtils.isRTL(context, menu);
        String string = iconPos = isRtl ? "right" : menuitem.getIconPos();
        if ("left".equals(iconPos)) {
            this.encodeIcon(writer, menu, menuitem, iconPos);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else if (value != null) {
            if (menuitem.isEscape()) {
                writer.writeText(value, "value");
            } else {
                writer.write(value.toString());
            }
        }
        writer.endElement("span");
        if ("right".equals(iconPos)) {
            this.encodeIcon(writer, menu, menuitem, iconPos);
        }
    }

    protected void encodeIcon(ResponseWriter writer, AbstractMenu menu, MenuItem menuitem, String iconPos) throws IOException {
        String icon = menuitem.getIcon();
        if (icon != null && LangUtils.isNotBlank(iconPos)) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon + " ui-menuitem-icon-" + iconPos), null);
            writer.writeAttribute("aria-hidden", (Object)"true", null);
            writer.endElement("span");
        }
    }

    protected void encodeOverlayConfig(FacesContext context, OverlayMenu menu, WidgetBuilder wb) throws IOException {
        wb.attr("overlay", true).attr("my", menu.getMy()).attr("at", menu.getAt());
        String trigger = menu.getTrigger();
        if (LangUtils.isNotBlank(trigger)) {
            wb.attr("trigger", SearchExpressionUtils.resolveClientIdsForClientSide(context, (UIComponent)menu, trigger)).attr("triggerEvent", menu.getTriggerEvent());
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeKeyboardTarget(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.endElement("div");
    }

    protected void encodeFacet(FacesContext context, AbstractMenu menu, String facetName, String styleClass) throws IOException {
        UIComponent facet = menu.getFacet(facetName);
        if (FacetUtils.shouldRenderFacet(facet)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.writeAttribute("role", (Object)"none", null);
            facet.encodeAll(context);
            writer.endElement("li");
        }
    }

    protected void encodeMenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.writeAttribute("aria-hidden", (Object)"true", null);
            writer.endElement("span");
        }
    }

    protected void encodeMenuLabel(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)label, "value");
            writer.endElement("span");
        }
    }

    protected void encodeSubmenuIcon(FacesContext context, Submenu submenu, boolean isRtl, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = isRtl ? "ui-icon ui-icon-triangle-1-w" : "ui-icon ui-icon-triangle-1-e";
        styleClass = isVertical ? styleClass : "ui-icon ui-icon-triangle-1-s";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.endElement("span");
    }
}

