/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panelgrid;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.panelgrid.PanelGrid;
import org.primefaces.component.row.Row;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.GridLayoutUtils;

public class PanelGridRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PanelGrid grid = (PanelGrid)component;
        String layout = grid.getLayout();
        if ("tabular".equalsIgnoreCase(layout)) {
            this.encodeLegacyTableLayout(context, grid);
        } else if ("grid".equalsIgnoreCase(layout) || "flex".equalsIgnoreCase(layout)) {
            this.encodeGridLayout(context, grid);
        } else {
            throw new FacesException("The value of 'layout' attribute of PanelGrid \"" + grid.getClientId(context) + "\" must be 'grid', 'tabular' or 'flex'. Default value is 'grid'.");
        }
    }

    public void encodeLegacyTableLayout(FacesContext context, PanelGrid grid) throws IOException {
        String clientId = grid.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        String style = grid.getStyle();
        Object styleClass = grid.getStyleClass();
        styleClass = styleClass == null ? "ui-panelgrid ui-widget" : "ui-panelgrid ui-widget " + (String)styleClass;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)grid.getRole(), null);
        this.encodeTableFacet(context, grid, columns, "header", "thead", "ui-panelgrid-header");
        this.encodeTableFacet(context, grid, columns, "footer", "tfoot", "ui-panelgrid-footer");
        this.encodeTableBody(context, grid, columns);
        writer.endElement("table");
    }

    public void encodeGridLayout(FacesContext context, PanelGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId(context);
        String layout = grid.getLayout();
        int columns = grid.getColumns();
        if (columns <= 0 || columns > 12 || 12 % columns != 0) {
            throw new FacesException("PanelGrid \"" + clientId + "\" columns must be a number that factors into 12. For example: 1,2,3,4,6,12");
        }
        String style = grid.getStyle();
        String containerClass = this.getStyleClassBuilder(context).add("ui-panelgrid ui-widget").add(grid.getStyleClass()).build();
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeGridFacet(context, grid, columns, "header", "ui-panelgrid-header");
        if ("flex".equalsIgnoreCase(layout)) {
            this.encodeFlexGridBody(context, grid, columns);
        } else {
            this.encodeGridBody(context, grid, columns);
        }
        this.encodeGridFacet(context, grid, columns, "footer", "ui-panelgrid-footer");
        writer.endElement("div");
    }

    public void encodeTableBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", (UIComponent)grid);
        if (columns > 0) {
            this.encodeDynamicBody(context, grid, grid.getColumns());
        } else {
            this.encodeStaticBody(context, grid);
        }
        writer.endElement("tbody");
    }

    public void encodeDynamicBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String columnClassesValue = grid.getColumnClasses();
        String[] columnClasses = columnClassesValue == null ? new String[]{} : columnClassesValue.split(",");
        int openendRows = 0;
        int closedRows = 0;
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            if (!child.isRendered()) continue;
            int colMod = i % columns;
            if (colMod == 0) {
                ++openendRows;
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-widget-content", null);
            }
            String columnClass = colMod < columnClasses.length ? "ui-panelgrid-cell " + columnClasses[colMod].trim() : "ui-panelgrid-cell";
            writer.startElement("td", null);
            writer.writeAttribute("role", (Object)"gridcell", null);
            writer.writeAttribute("class", (Object)columnClass, null);
            child.encodeAll(context);
            writer.endElement("td");
            if ((colMod = ++i % columns) != 0) continue;
            ++closedRows;
            writer.endElement("tr");
        }
        if (openendRows > closedRows) {
            writer.endElement("tr");
        }
    }

    public void encodeStaticBody(FacesContext context, PanelGrid grid) throws IOException {
        context.getAttributes().put("org.primefaces.HELPER_RENDERER", "panelGridBody");
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            if (child instanceof Row || ComponentUtils.isUIRepeat(child)) {
                ++i;
            }
            if (!child.isRendered()) continue;
            if (child instanceof Row) {
                String rowStyleClass = i % 2 == 0 ? "ui-widget-content ui-panelgrid-even" : "ui-widget-content ui-panelgrid-odd";
                this.encodeRow(context, (Row)child, "gridcell", rowStyleClass, "ui-panelgrid-cell");
                continue;
            }
            child.encodeAll(context);
        }
        if (i == 0) {
            throw new FacesException("PanelGrid \"" + grid.getClientId(context) + "\" without a 'columns' attribute expects at least one <p:row> element.");
        }
        context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
    }

    public void encodeRow(FacesContext context, Row row, String columnRole, String rowClass, String columnClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = row.getStyle();
        writer.startElement("tr", null);
        if (this.shouldWriteId((UIComponent)row)) {
            writer.writeAttribute("id", (Object)row.getClientId(context), null);
        }
        if (row.getStyleClass() != null) {
            rowClass = (String)rowClass + " " + row.getStyleClass();
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("class", rowClass, null);
        for (UIComponent child : row.getChildren()) {
            if (child instanceof Column && child.isRendered()) {
                Column column = (Column)child;
                String userStyleClass = column.getStyleClass();
                String styleClass = userStyleClass == null ? columnClass : columnClass + " " + userStyleClass;
                writer.startElement("td", null);
                if (this.shouldWriteId((UIComponent)column)) {
                    writer.writeAttribute("id", (Object)column.getClientId(context), null);
                }
                writer.writeAttribute("role", (Object)columnRole, null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (column.getColspan() > 1) {
                    writer.writeAttribute("colspan", (Object)column.getColspan(), null);
                }
                if (column.getRowspan() > 1) {
                    writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
                }
                this.renderChildren(context, (UIComponent)column);
                writer.endElement("td");
                continue;
            }
            child.encodeAll(context);
        }
        writer.endElement("tr");
    }

    public void encodeGridBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        String clientId = grid.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String columnClassesValue = grid.getColumnClasses();
        String[] columnClasses = columnClassesValue == null ? new String[]{} : columnClassesValue.split(",");
        String contentClass = this.getStyleClassBuilder(context).add("ui-panelgrid-content ui-widget-content").add(GridLayoutUtils.getResponsiveClass(false)).add(grid.getContentStyleClass()).build();
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (grid.getContentStyle() != null) {
            writer.writeAttribute("style", (Object)grid.getContentStyle(), null);
        }
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            int colMod;
            if (!child.isRendered()) continue;
            Row row = null;
            if (child instanceof Row) {
                if (i > 0) {
                    writer.endElement("div");
                }
                row = (Row)child;
                i = 0;
            }
            if ((colMod = i % columns) == 0) {
                Object rowClass;
                writer.startElement("div", null);
                Object object = rowClass = columnClasses.length > 0 && columnClasses[0].contains("ui-grid-col-") ? "ui-grid-row" : "ui-g";
                if (row != null) {
                    if (row.getId() != null) {
                        writer.writeAttribute("id", (Object)row.getClientId(context), null);
                    }
                    if (row.getStyle() != null) {
                        writer.writeAttribute("style", (Object)row.getStyle(), null);
                    }
                    if (row.getStyleClass() != null) {
                        rowClass = (String)rowClass + " " + row.getStyleClass();
                    }
                }
                writer.writeAttribute("class", rowClass, null);
            }
            if (row == null) {
                this.encodeColumn(context, columns, writer, columnClasses, child, colMod);
            } else {
                int iRow = 0;
                int classesLength = columnClasses.length > 0 ? columnClasses.length : 1;
                for (UIComponent rowChild : row.getChildren()) {
                    this.encodeColumn(context, columns, writer, columnClasses, rowChild, iRow % classesLength);
                    ++iRow;
                }
            }
            if ((colMod = ++i % columns) != 0 && row == null) continue;
            writer.endElement("div");
            i = 0;
        }
        if (i != 0 && i % columns != 0) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeFlexGridBody(FacesContext context, PanelGrid grid, int columns) throws IOException {
        String clientId = grid.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String columnClassesValue = grid.getColumnClasses();
        String[] columnClasses = columnClassesValue == null ? new String[]{} : columnClassesValue.split(",");
        String contentClass = this.getStyleClassBuilder(context).add("ui-panelgrid-content ui-widget-content").add(GridLayoutUtils.getFlexGridClass(true)).add(grid.getContentStyleClass()).build();
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (grid.getContentStyle() != null) {
            writer.writeAttribute("style", (Object)grid.getContentStyle(), null);
        }
        int i = 0;
        for (UIComponent child : grid.getChildren()) {
            Column column;
            Object columnClass;
            if (!child.isRendered()) continue;
            int colMod = i % columns;
            Object object = columnClass = colMod < columnClasses.length ? "ui-panelgrid-cell " + columnClasses[colMod].trim() : "ui-panelgrid-cell";
            if (!((String)columnClass).contains("md-") && !((String)columnClass).contains("col-")) {
                columnClass = (String)columnClass + " " + GridLayoutUtils.getFlexColumnClass(columns);
            }
            writer.startElement("div", null);
            Column column2 = column = child instanceof Column ? (Column)child : null;
            if (column != null) {
                if (column.getId() != null) {
                    writer.writeAttribute("id", (Object)column.getClientId(context), null);
                }
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (column.getStyleClass() != null) {
                    columnClass = (String)columnClass + (String)columnClass + " " + column.getStyleClass();
                }
            }
            writer.writeAttribute("class", columnClass, null);
            child.encodeAll(context);
            writer.endElement("div");
            ++i;
        }
        writer.endElement("div");
    }

    private void encodeColumn(FacesContext context, int columns, ResponseWriter writer, String[] columnClasses, UIComponent child, int colMod) throws IOException {
        Column column;
        Object columnClass;
        Object object = columnClass = colMod < columnClasses.length ? "ui-panelgrid-cell " + columnClasses[colMod].trim() : "ui-panelgrid-cell";
        if (!(((String)columnClass).contains("ui-md-") || ((String)columnClass).contains("ui-g-") || ((String)columnClass).contains("ui-grid-col-"))) {
            columnClass = (String)columnClass + " " + GridLayoutUtils.getColumnClass(columns);
        }
        writer.startElement("div", null);
        Column column2 = column = child instanceof Column ? (Column)child : null;
        if (column != null) {
            if (column.getId() != null) {
                writer.writeAttribute("id", (Object)column.getClientId(context), null);
            }
            if (column.getStyle() != null) {
                writer.writeAttribute("style", (Object)column.getStyle(), null);
            }
            if (column.getStyleClass() != null) {
                columnClass = "ui-panelgrid-cell " + column.getStyleClass();
            }
        }
        writer.writeAttribute("class", columnClass, null);
        child.encodeAll(context);
        writer.endElement("div");
    }

    public void encodeTableFacet(FacesContext context, PanelGrid grid, int columns, String facet, String tag, String styleClass) throws IOException {
        UIComponent component = grid.getFacet(facet);
        if (FacetUtils.shouldRenderFacet(component)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tag, null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (columns > 0) {
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-widget-header", null);
                writer.startElement("td", null);
                writer.writeAttribute("colspan", (Object)columns, null);
                writer.writeAttribute("role", (Object)"columnheader", null);
                writer.writeAttribute("class", (Object)"ui-panelgrid-cell ui-widget-header", null);
                component.encodeAll(context);
                writer.endElement("td");
                writer.endElement("tr");
            } else {
                context.getAttributes().put("org.primefaces.HELPER_RENDERER", "panelGridFacet");
                if (component instanceof Row) {
                    this.encodeRow(context, (Row)component, "columnheader", "ui-widget-header", "ui-panelgrid-cell ui-widget-header");
                } else if (component instanceof UIPanel) {
                    for (UIComponent child : component.getChildren()) {
                        if (!child.isRendered()) continue;
                        if (child instanceof Row) {
                            this.encodeRow(context, (Row)child, "columnheader", "ui-widget-header", "ui-panelgrid-cell ui-widget-header");
                            continue;
                        }
                        component.encodeAll(context);
                    }
                } else {
                    component.encodeAll(context);
                }
                context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
            }
            writer.endElement(tag);
        }
    }

    public void encodeGridFacet(FacesContext context, PanelGrid grid, int columns, String facet, String styleClass) throws IOException {
        UIComponent component = grid.getFacet(facet);
        if (FacetUtils.shouldRenderFacet(component)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)(styleClass + " ui-widget-header"), null);
            component.encodeAll(context);
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

