/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonemenu;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectonemenu.SelectOneMenu;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class SelectOneMenuRenderer
extends SelectOneRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
        SelectOneMenu menu = (SelectOneMenu)component;
        if (!this.shouldDecode((UIInput)menu)) {
            return;
        }
        if (menu.isEditable()) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String editorInput = (String)params.get(menu.getClientId(context) + "_editableInput");
            menu.setSubmittedValue(editorInput);
            if (LangUtils.isNotBlank(editorInput)) {
                List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
                Converter converter = menu.getConverter();
                SelectItem foundItem = this.findSelectItemByLabel(context, (UIComponent)menu, converter, selectItems, editorInput);
                if (foundItem != null) {
                    menu.setSubmittedValue(this.getOptionAsString(context, (UIComponent)menu, converter, foundItem.getValue()));
                }
            }
            this.decodeBehaviors(context, (UIComponent)menu);
        } else {
            super.decode(context, component);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectOne", "javax.faces.Menu");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneMenu menu = (SelectOneMenu)component;
        if (menu.isDynamicLoadRequest(context)) {
            List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
            String clientId = menu.getClientId(context);
            Converter converter = menu.getConverter();
            Object values = this.getValues((UISelectOne)menu);
            Object submittedValues = this.getSubmittedValues((UIComponent)menu);
            this.encodeHiddenSelect(context, menu, clientId, selectItems, values, submittedValues, converter);
            this.encodePanelContent(context, menu, selectItems);
        } else {
            this.encodeMarkup(context, menu);
            this.encodeScript(context, menu);
        }
    }

    protected void encodeMarkup(FacesContext context, SelectOneMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        String clientId = menu.getClientId(context);
        Converter converter = menu.getConverter();
        Object values = this.getValues((UISelectOne)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        boolean valid = menu.isValid();
        String title = menu.getTitle();
        String style = menu.getStyle();
        Object styleClass = this.createStyleClass((UIInput)menu, "ui-selectonemenu ui-widget ui-state-default ui-corner-all");
        if (ComponentUtils.isRTL(context, menu)) {
            styleClass = (String)styleClass + " ui-selectonemenu-rtl";
        }
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.encodeInput(context, menu, clientId, selectItems, values, submittedValues, converter);
        this.encodeLabel(context, menu, selectItems);
        this.encodeMenuIcon(context, menu, valid);
        this.encodePanel(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, SelectOneMenu menu, String clientId, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (menu.isEditable()) {
            String focusId = clientId + "_focus";
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)focusId, null);
            writer.writeAttribute("name", (Object)focusId, null);
            writer.writeAttribute("type", (Object)"text", null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            writer.writeAttribute("role", (Object)"combobox", null);
            this.renderAccessibilityAttributes(context, (UIInput)menu);
            this.renderPassThruAttributes(context, (UIComponent)menu, HTML.TAB_INDEX);
            this.renderDomEvents(context, (UIComponent)menu, HTML.BLUR_FOCUS_EVENTS);
            writer.endElement("input");
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        this.encodeHiddenSelect(context, menu, clientId, selectItems, values, submittedValues, converter);
        writer.endElement("div");
    }

    protected void encodeHiddenSelect(FacesContext context, SelectOneMenu menu, String clientId, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        this.encodeAriaLabel(writer, menu);
        if (menu.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (menu.getOnkeydown() != null) {
            writer.writeAttribute("onkeydown", (Object)menu.getOnkeydown(), null);
        }
        if (menu.getOnkeyup() != null) {
            writer.writeAttribute("onkeyup", (Object)menu.getOnkeyup(), null);
        }
        this.renderOnchange(context, (UIComponent)menu);
        this.renderValidationMetadata(context, (EditableValueHolder)menu, new ClientValidator[0]);
        this.encodeSelectItems(context, menu, selectItems, values, submittedValues, converter);
        writer.endElement("select");
    }

    protected void encodeAriaLabel(ResponseWriter writer, SelectOneMenu menu) throws IOException {
        String ariaLabel = Objects.toString(menu.getAttributes().get("aria-label"), null);
        if (LangUtils.isBlank(ariaLabel)) {
            String label = menu.getLabel();
            String string = ariaLabel = LangUtils.isBlank(label) ? menu.getPlaceholder() : label;
        }
        if (LangUtils.isNotBlank(ariaLabel)) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
    }

    protected void encodeLabel(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        String tabIndex;
        ResponseWriter writer = context.getResponseWriter();
        String string = tabIndex = LangUtils.isNotBlank(menu.getTabindex()) ? menu.getTabindex() : "0";
        if (menu.isEditable()) {
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_editableInput"), null);
            writer.writeAttribute("type", (Object)"text", null);
            writer.writeAttribute("name", (Object)(menu.getClientId(context) + "_editableInput"), null);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-label ui-inputfield ui-corner-all", null);
            writer.writeAttribute("tabindex", (Object)tabIndex, null);
            this.encodeAriaLabel(writer, menu);
            if (menu.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            this.renderAccessibilityAttributes(context, (UIInput)menu);
            String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)menu);
            for (int i = 0; i < selectItems.size(); ++i) {
                SelectItem selectItem = selectItems.get(i);
                if (!this.isSelected(context, (UIComponent)menu, valueToRender, selectItem.getValue(), null)) continue;
                valueToRender = selectItem.getLabel();
                break;
            }
            writer.writeAttribute("value", (Object)valueToRender, null);
            if (menu.getMaxlength() != Integer.MAX_VALUE) {
                writer.writeAttribute("maxlength", (Object)menu.getMaxlength(), null);
            }
            if (menu.getPlaceholder() != null) {
                writer.writeAttribute("placeholder", (Object)menu.getPlaceholder(), null);
            }
            if (menu.getOnkeydown() != null) {
                writer.writeAttribute("onkeydown", (Object)menu.getOnkeydown(), null);
                this.renderDomEvent(context, (UIComponent)menu, "onkeydown", "keydown", "keydown", null);
            }
            if (menu.getOnkeyup() != null) {
                writer.writeAttribute("onkeyup", (Object)menu.getOnkeyup(), null);
                this.renderDomEvent(context, (UIComponent)menu, "onkeyup", "keyup", "keyup", null);
            }
            writer.endElement("input");
        } else {
            String clientId = menu.getClientId(context);
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_label"), null);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-label ui-inputfield ui-corner-all", null);
            writer.writeAttribute("tabindex", (Object)tabIndex, null);
            if (menu.getPlaceholder() != null) {
                writer.writeAttribute("data-placeholder", (Object)menu.getPlaceholder(), null);
            }
            writer.writeAttribute("aria-controls", (Object)(clientId + "_panel"), null);
            this.renderARIACombobox(context, (UIInput)menu);
            this.renderAccessibilityAttributes(context, (UIInput)menu);
            this.renderPassThruAttributes(context, (UIComponent)menu, HTML.TAB_INDEX);
            this.renderDomEvents(context, (UIComponent)menu, HTML.BLUR_FOCUS_EVENTS);
            String label = menu.getLabel();
            if (label != null) {
                writer.writeText((Object)label, null);
            }
            writer.write("&nbsp;");
            writer.endElement("span");
        }
    }

    protected void encodeMenuIcon(FacesContext context, SelectOneMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectonemenu-trigger ui-state-default ui-corner-right" : "ui-selectonemenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s ui-c", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String panelStyle = menu.getPanelStyle();
        Object panelStyleClass = menu.getPanelStyleClass();
        Object object = panelStyleClass = panelStyleClass == null ? "ui-selectonemenu-panel ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-shadow ui-input-overlay" : "ui-selectonemenu-panel ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-shadow ui-input-overlay " + (String)panelStyleClass;
        if (ComponentUtils.isRTL(context, menu)) {
            panelStyleClass = (String)panelStyleClass + " ui-selectonemenu-panel-rtl";
        }
        Object height = null;
        try {
            height = Integer.parseInt(menu.getHeight()) + "px";
        }
        catch (NumberFormatException e) {
            height = menu.getHeight();
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", panelStyleClass, null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (panelStyle != null) {
            writer.writeAttribute("style", (Object)panelStyle, null);
        }
        if (menu.isFilter()) {
            this.encodeFilter(context, menu);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectonemenu-items-wrapper", null);
        writer.writeAttribute("style", (Object)("max-height:" + (String)height), null);
        if (!menu.isDynamic()) {
            this.encodePanelContent(context, menu, selectItems);
        }
        writer.endElement("div");
        this.encodePanelFooter(context, menu);
        writer.endElement("div");
    }

    protected void encodePanelContent(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems) throws IOException {
        boolean customContent;
        ResponseWriter writer = context.getResponseWriter();
        boolean bl = customContent = menu.getVar() != null;
        if (customContent) {
            List<Column> columns = menu.getColumns();
            writer.startElement("table", null);
            writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_table"), null);
            writer.writeAttribute("class", (Object)"ui-selectonemenu-items ui-selectonemenu-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
            writer.writeAttribute("role", (Object)"listbox", null);
            this.encodeColumnsHeader(context, menu, columns);
            writer.startElement("tbody", null);
            this.encodeOptionsAsTable(context, menu, selectItems, columns);
            writer.endElement("tbody");
            writer.endElement("table");
        }
    }

    protected void encodePanelFooter(FacesContext context, SelectOneMenu menu) throws IOException {
        UIComponent facet = menu.getFacet("footer");
        if (!FacetUtils.shouldRenderFacet(facet)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectonemenu-footer", null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeColumnsHeader(FacesContext context, SelectOneMenu menu, List<Column> columns) throws IOException {
        Column column;
        int i;
        ResponseWriter writer = context.getResponseWriter();
        boolean hasHeader = false;
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (!column.isRendered() || column.getHeaderText() == null && column.getFacet("header") == null) continue;
            hasHeader = true;
            break;
        }
        if (hasHeader) {
            writer.startElement("thead", null);
            for (i = 0; i < columns.size(); ++i) {
                UIComponent headerFacet;
                column = columns.get(i);
                if (!column.isRendered()) continue;
                String headerText = column.getHeaderText();
                String styleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                writer.startElement("th", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (FacetUtils.shouldRenderFacet(headerFacet = column.getFacet("header"))) {
                    headerFacet.encodeAll(context);
                } else if (headerText != null) {
                    writer.writeText((Object)headerText, null);
                }
                writer.endElement("th");
            }
            writer.endElement("thead");
        }
    }

    protected void encodeOptionsAsTable(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems, List<Column> columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = menu.getVar();
        ValueExpression value = menu.getValueExpression("value");
        Class valueType = value == null ? null : value.getType(context.getELContext());
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            Object itemValue = selectItem.getValue();
            String itemLabel = this.getOptionLabel(selectItem);
            Object itemStyleClass = "ui-selectonemenu-item ui-selectonemenu-row ui-widget-content";
            if (selectItem.isNoSelectionOption()) {
                itemStyleClass = (String)itemStyleClass + " ui-noselection-option";
            }
            if (selectItem.isDisabled()) {
                itemStyleClass = (String)itemStyleClass + " ui-state-disabled";
            }
            context.getExternalContext().getRequestMap().put(var, itemValue);
            writer.startElement("tr", this.getSelectItemComponent(selectItem));
            writer.writeAttribute("class", itemStyleClass, null);
            writer.writeAttribute("data-label", (Object)itemLabel, null);
            writer.writeAttribute("role", (Object)"option", null);
            if (selectItem.getDescription() != null) {
                writer.writeAttribute("title", (Object)selectItem.getDescription(), null);
            }
            if (itemValue == null || valueType != null && !valueType.isAssignableFrom(itemValue.getClass())) {
                writer.startElement("td", null);
                writer.writeAttribute("colspan", (Object)columns.size(), null);
                writer.writeText((Object)selectItem.getLabel(), null);
                writer.endElement("td");
            } else {
                for (int j = 0; j < columns.size(); ++j) {
                    Column column = columns.get(j);
                    if (!column.isRendered()) continue;
                    String style = column.getStyle();
                    String styleClass = column.getStyleClass();
                    writer.startElement("td", null);
                    if (style != null) {
                        writer.writeAttribute("style", (Object)style, null);
                    }
                    if (styleClass != null) {
                        writer.writeAttribute("class", (Object)styleClass, null);
                    }
                    this.encodeIndexedId(context, (UIComponent)column, i);
                    writer.endElement("td");
                }
            }
            writer.endElement("tr");
        }
        context.getExternalContext().getRequestMap().put(var, null);
    }

    protected void encodeScript(FacesContext context, SelectOneMenu menu) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectOneMenu", menu).attr("editable", menu.isEditable(), false).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)menu, menu.getAppendTo())).attr("syncTooltip", menu.isSyncTooltip(), false).attr("alwaysDisplayLabel", menu.isAlwaysDisplayLabel(), false).attr("label", menu.getLabel(), null).attr("labelTemplate", menu.getLabelTemplate(), null).attr("autoWidth", menu.getAutoWidth(), "auto").attr("dynamic", menu.isDynamic(), false).attr("touchable", ComponentUtils.isTouchable(context, menu), true).attr("renderPanelContentOnClient", menu.getVar() == null, false);
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false).attr("filterNormalize", menu.isFilterNormalize(), false);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    protected void encodeSelectItems(FacesContext context, SelectOneMenu menu, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        boolean isInitialDynamic = menu.isDynamic() && !menu.isDynamicLoadRequest(context);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            boolean selected = this.encodeOption(context, menu, selectItem, values, submittedValues, converter, i);
            if (!selected || !isInitialDynamic) continue;
            return;
        }
    }

    protected boolean encodeOption(FacesContext context, SelectOneMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter, int itemIndex) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        if (option instanceof SelectItemGroup) {
            SelectItemGroup group = (SelectItemGroup)option;
            writer.startElement("optgroup", null);
            writer.writeAttribute("label", (Object)group.getLabel(), null);
            if (group.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.writeAttribute("data-escape", (Object)String.valueOf(group.isEscape()), null);
            if (option.getDescription() != null) {
                writer.writeAttribute("data-title", (Object)option.getDescription(), null);
            }
            for (SelectItem groupItem : group.getSelectItems()) {
                this.encodeOption(context, menu, groupItem, values, submittedValues, converter, itemIndex);
            }
            writer.endElement("optgroup");
            return false;
        }
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean disabled = option.isDisabled();
        boolean isEscape = option.isEscape();
        boolean isNoSelectionOption = option.isNoSelectionOption();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (!menu.isDynamic() || menu.isDynamic() && (selected || menu.isDynamicLoadRequest(context) || itemIndex == 0)) {
            writer.startElement("option", this.getSelectItemComponent(option));
            writer.writeAttribute("value", (Object)itemValueAsString, null);
            if (disabled) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            if (selected) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (isNoSelectionOption) {
                writer.writeAttribute("data-noselection-option", (Object)"true", null);
            }
            writer.writeAttribute("data-escape", (Object)String.valueOf(isEscape), null);
            if (option.getDescription() != null) {
                writer.writeAttribute("data-title", (Object)option.getDescription(), null);
            }
            writer.writeText((Object)this.getOptionLabel(option), null);
            writer.endElement("option");
        }
        return selected;
    }

    protected String getOptionLabel(SelectItem option) {
        String itemLabel = option.getLabel();
        return this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }

    protected void encodeFilter(FacesContext context, SelectOneMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = menu.getClientId(context) + "_filter";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectonemenu-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)"ui-selectonemenu-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-controls", (Object)(menu.getClientId(context) + "_table"), null);
        if (menu.getFilterPlaceholder() != null) {
            writer.writeAttribute("placeholder", (Object)menu.getFilterPlaceholder(), null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.endElement("div");
    }

    @Override
    public String getHighlighter() {
        return "onemenu";
    }
}

