/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitter;

import java.io.IOException;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.splitter.Splitter;
import org.primefaces.component.splitter.SplitterPanel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class SplitterRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Splitter splitter = (Splitter)component;
        this.encodeMarkup(context, splitter);
        this.encodeScript(context, splitter);
    }

    protected void encodeMarkup(FacesContext context, Splitter splitter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String layout = splitter.getLayout();
        boolean isVertical = "vertical".equals(layout);
        String styleClass = this.getStyleClassBuilder(context).add("ui-splitter ui-widget").add(splitter.getStyleClass()).add(isVertical, "ui-splitter-vertical").add("horizontal".equals(layout), "ui-splitter-horizontal").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)splitter.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (splitter.getStyle() != null) {
            writer.writeAttribute("style", (Object)splitter.getStyle(), "style");
        }
        int childCount = splitter.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String minSize;
            UIComponent component = (UIComponent)splitter.getChildren().get(i);
            if (!(component instanceof SplitterPanel)) continue;
            SplitterPanel panel = (SplitterPanel)component;
            String panelId = this.encodePanel(context, panel, i);
            String valueNow = panel.getSize() == null ? "0" : panel.getSize().toString();
            String string = minSize = panel.getMinSize() == null ? "0" : panel.getMinSize().toString();
            if (i == childCount - 1) continue;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-splitter-gutter", null);
            writer.writeAttribute("role", (Object)"separator", null);
            if ("horizontal".equals(layout)) {
                writer.writeAttribute("style", (Object)("width: " + splitter.getGutterSize() + "px"), null);
            } else if ("vertical".equals(layout)) {
                writer.writeAttribute("style", (Object)("height: " + splitter.getGutterSize() + "px"), null);
            }
            writer.startElement("div", (UIComponent)splitter);
            writer.writeAttribute("class", (Object)"ui-splitter-gutter-handle", null);
            writer.writeAttribute("tabindex", (Object)Objects.toString(panel.getTabindex(), "0"), null);
            writer.writeAttribute("aria-controls", (Object)panelId, null);
            writer.writeAttribute("aria-orientation", (Object)(isVertical ? "horizontal" : "vertical"), null);
            writer.writeAttribute("aria-controls", (Object)panelId, null);
            writer.writeAttribute("aria-valuemin", (Object)minSize, null);
            writer.writeAttribute("aria-valuemax", (Object)"100", null);
            writer.writeAttribute("aria-valuenow", (Object)valueNow, null);
            writer.writeAttribute("aria-valuetext", (Object)(valueNow + "%"), null);
            if (LangUtils.isNotBlank(panel.getAriaLabel())) {
                writer.writeAttribute("aria-label", (Object)panel.getAriaLabel(), null);
            }
            if (LangUtils.isNotBlank(panel.getAriaLabelledBy())) {
                writer.writeAttribute("aria-labelledby", (Object)panel.getAriaLabelledBy(), null);
            }
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected String encodePanel(FacesContext context, SplitterPanel splitterPanel, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = splitterPanel.getClientId(context) + "_" + index;
        String styleClass = this.getStyleClassBuilder(context).add("ui-splitter-panel").add(splitterPanel.getStyleClass()).add(splitterPanel.isNested(), "ui-splitter-panel-nested").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("role", (Object)"presentation", null);
        writer.writeAttribute("data-size", (Object)splitterPanel.getSize(), null);
        writer.writeAttribute("data-minsize", (Object)splitterPanel.getMinSize(), null);
        if (splitterPanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)splitterPanel.getStyle(), "style");
        }
        splitterPanel.encodeAll(context);
        writer.endElement("div");
        return id;
    }

    protected void encodeScript(FacesContext context, Splitter splitter) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Splitter", splitter).attr("layout", splitter.getLayout()).attr("gutterSize", splitter.getGutterSize()).attr("step", splitter.getStep()).attr("stateKey", splitter.getStateKey()).attr("stateStorage", splitter.getStateStorage());
        wb.callback("onResizeEnd", "function(panelSizes)", splitter.getOnResizeEnd());
        this.encodeClientBehaviors(context, splitter);
        wb.finish();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

