/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.staticmessage;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.staticmessage.StaticMessage;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.WidgetBuilder;

public class StaticMessageRenderer
extends UINotificationRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        StaticMessage staticMessage = (StaticMessage)component;
        ResponseWriter writer = context.getResponseWriter();
        String display = staticMessage.getDisplay();
        boolean iconOnly = "icon".equals(display);
        boolean escape = staticMessage.isEscape();
        String summary = staticMessage.getSummary();
        String detail = staticMessage.getDetail();
        String severity = staticMessage.getSeverity();
        severity = severity == null ? "info" : severity.toLowerCase();
        String styleClass = this.getStyleClassBuilder(context).add("ui-message ui-staticmessage ui-message-" + severity + " ui-widget ui-corner-all").add(iconOnly, "ui-message-icon-only ui-helper-clearfix").add(staticMessage.getStyleClass()).build();
        String style = staticMessage.getStyle();
        writer.startElement("div", (UIComponent)staticMessage);
        writer.writeAttribute("id", (Object)staticMessage.getClientId(context), null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (staticMessage.isClosable()) {
            this.encodeCloseIcon(context, staticMessage);
        }
        if (!"text".equals(display)) {
            this.encodeIcon(writer, severity, detail, iconOnly);
        }
        if (!iconOnly) {
            this.encodeText(writer, summary, severity + "-summary", escape);
            this.encodeText(writer, detail, severity + "-detail", escape);
        }
        writer.endElement("div");
        this.encodeScript(context, staticMessage);
    }

    protected void encodeText(ResponseWriter writer, String text, String severity, boolean escape) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        if (text != null) {
            if (escape) {
                writer.writeText((Object)text, null);
            } else {
                writer.write(text);
            }
        }
        writer.endElement("span");
    }

    protected void encodeIcon(ResponseWriter writer, String severity, String title, boolean iconOnly) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity + "-icon"), null);
        if (iconOnly && title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.endElement("span");
    }

    protected void encodeCloseIcon(FacesContext context, StaticMessage staticMessage) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-messages-close", null);
        writer.writeAttribute("onclick", (Object)"$(this).parent().slideUp();return false;", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeScript(FacesContext context, StaticMessage staticMessage) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("StaticMessage", staticMessage);
        this.encodeClientBehaviors(context, staticMessage);
        wb.finish();
    }
}

