/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.CSVOptions;
import org.primefaces.component.export.ColumnValue;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.util.LangUtils;

public class TreeTableCSVExporter
extends TreeTableExporter<PrintWriter, CSVOptions> {
    public TreeTableCSVExporter() {
        super(CSVOptions.EXCEL, Collections.emptySet(), false);
    }

    @Override
    protected void postExport(FacesContext context) throws IOException {
        super.postExport(context);
        if (this.document != null) {
            ((PrintWriter)this.document).flush();
        }
    }

    @Override
    protected PrintWriter createDocument(FacesContext context) throws IOException {
        try {
            String encoding = this.exportConfiguration.getEncodingType();
            OutputStreamWriter osw = new OutputStreamWriter(this.os(), encoding);
            PrintWriter writer = new PrintWriter(osw);
            if (StandardCharsets.UTF_8.name().equals(encoding)) {
                writer.write("\ufeff");
            }
            return writer;
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    protected void postRowExport(FacesContext context, TreeTable table) {
        ((PrintWriter)this.document).append(((CSVOptions)this.options()).getEndOfLineSymbols());
        super.postRowExport(context, table);
    }

    @Override
    protected void exportColumnFacetValue(FacesContext context, TreeTable table, ColumnValue columnValue, int index) {
        if (index != 0) {
            ((PrintWriter)this.document).append(((CSVOptions)this.options()).getDelimiterChar());
        }
        String text = columnValue.toString();
        String exportValue = "";
        if (LangUtils.isNotBlank(text)) {
            exportValue = text.replace(((CSVOptions)this.options()).getQuoteString(), ((CSVOptions)this.options()).getDoubleQuoteString());
        }
        ((PrintWriter)this.document).append(((CSVOptions)this.options()).getQuoteChar()).append(exportValue).append(((CSVOptions)this.options()).getQuoteChar());
    }

    @Override
    protected void exportCellValue(FacesContext context, TreeTable table, UIColumn col, ColumnValue columnValue, int index) {
        if (index != 0) {
            ((PrintWriter)this.document).append(((CSVOptions)this.options()).getDelimiterChar());
        }
        ((PrintWriter)this.document).append(((CSVOptions)this.options()).getQuoteChar()).append(this.escapeQuotes(columnValue.toString())).append(((CSVOptions)this.options()).getQuoteChar());
    }

    @Override
    public String getContentType() {
        return "text/csv";
    }

    @Override
    public String getFileExtension() {
        return ".csv";
    }

    protected String escapeQuotes(String value) {
        return value == null ? "" : value.replace(((CSVOptions)this.options()).getQuoteString(), ((CSVOptions)this.options()).getDoubleQuoteString());
    }
}

