/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.context.PrimePartialResponseWriter;
import org.primefaces.csp.CspPartialResponseWriter;

public class PrimePartialViewContext
extends PartialViewContextWrapper {
    private PartialResponseWriter writer;

    public PrimePartialViewContext(PartialViewContext wrapped) {
        super(wrapped);
    }

    public void processPartial(PhaseId phaseId) {
        this.getWrapped().processPartial(phaseId);
    }

    public void setPartialRequest(boolean value) {
        this.getWrapped().setPartialRequest(value);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            PartialResponseWriter parentWriter = this.getWrapped().getPartialResponseWriter();
            this.writer = new PrimePartialResponseWriter(parentWriter);
            FacesContext context = FacesContext.getCurrentInstance();
            PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
            if (config.isCsp()) {
                this.writer = new CspPartialResponseWriter(this.writer, context, PrimeFacesContext.getCspState(context));
            }
        }
        return this.writer;
    }

    public boolean isAjaxRequest() {
        return this.getWrapped().isAjaxRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.ajax");
    }

    public boolean isPartialRequest() {
        return this.getWrapped().isPartialRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.execute");
    }
}

