/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.LazyTreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeChildren;
import org.primefaces.util.SerializableFunction;

public class LazyDefaultTreeNode<T>
extends DefaultTreeNode<T>
implements LazyTreeNode {
    private SerializableFunction<T, List<T>> loadFunction;
    private SerializableFunction<T, Boolean> isLeafFunction;
    private boolean loaded;

    public LazyDefaultTreeNode() {
    }

    public LazyDefaultTreeNode(T data, SerializableFunction<T, List<T>> loadFunction, SerializableFunction<T, Boolean> isLeafFunction) {
        super(data);
        this.loadFunction = loadFunction;
        this.isLeafFunction = isLeafFunction;
    }

    @Override
    public List<TreeNode<T>> getChildren() {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        this.lazyLoad();
        return super.getChildren();
    }

    @Override
    public int getChildCount() {
        if (this.isLeaf()) {
            return 0;
        }
        this.lazyLoad();
        return super.getChildCount();
    }

    @Override
    public boolean isLeaf() {
        return (Boolean)this.isLeafFunction.apply(this.getData());
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    protected void lazyLoad() {
        if (!this.loaded) {
            this.loaded = true;
            List childData = (List)this.loadFunction.apply(this.getData());
            List childNodes = childData.stream().map(f -> new LazyDefaultTreeNode<Object>(f, this.loadFunction, this.isLeafFunction)).collect(Collectors.toList());
            super.getChildren().addAll(childNodes);
        }
    }

    @Override
    protected List<TreeNode<T>> initChildren() {
        return new LazyTreeNodeChildren(this);
    }

    public static class LazyTreeNodeChildren<T>
    extends TreeNodeChildren<T> {
        public LazyTreeNodeChildren() {
        }

        public LazyTreeNodeChildren(LazyDefaultTreeNode parent) {
            super(parent);
        }

        @Override
        protected void updateRowKeys(TreeNode node) {
            if (((LazyDefaultTreeNode)node).loaded) {
                super.updateRowKeys(node);
            }
        }

        @Override
        protected void updateRowKeys(int index, TreeNode node) {
            if (((LazyDefaultTreeNode)node).loaded) {
                super.updateRowKeys(index, node);
            }
        }

        @Override
        protected void updateRowKeys(TreeNode node, TreeNode childNode, int i) {
            if (((LazyDefaultTreeNode)node).loaded) {
                super.updateRowKeys(node, childNode, i);
            }
        }
    }
}

