/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.faces.FacesException;
import org.primefaces.model.file.AbstractUploadedFile;

public class NIOUploadedFile
extends AbstractUploadedFile<Path>
implements Serializable {
    private String contentType;

    public NIOUploadedFile() {
    }

    public NIOUploadedFile(Path source, String filename, String contentType, Long sizeLimit, String webKitRelativePath) {
        super(source, filename, sizeLimit, webKitRelativePath);
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getSize() {
        try {
            return Files.size((Path)this.getSource());
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public void delete() throws IOException {
        Files.delete((Path)this.getSource());
    }

    @Override
    protected InputStream getSourceInputStream() throws IOException {
        return Files.newInputStream((Path)this.getSource(), new OpenOption[0]);
    }

    @Override
    protected void write(File file) throws IOException {
        Files.copy((Path)this.getSource(), file.toPath(), new CopyOption[0]);
    }
}

