/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.timeline;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.primefaces.component.timeline.TimelineUpdater;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineEventComparator;
import org.primefaces.model.timeline.TimelineGroup;

public class TimelineModel<E, G>
implements Serializable {
    private static final long serialVersionUID = 20130316L;
    private List<TimelineEvent<E>> events = new ArrayList<TimelineEvent<E>>();
    private List<TimelineGroup<G>> groups;

    public TimelineModel() {
    }

    public TimelineModel(List<TimelineEvent<E>> events) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent<E> event : events) {
                this.add(event);
            }
        }
    }

    public TimelineModel(List<TimelineEvent<E>> events, List<TimelineGroup<G>> groups) {
        this(events);
        this.groups = groups;
    }

    public void add(TimelineEvent<E> event) {
        this.events.add(event);
    }

    public void addGroup(TimelineGroup<G> group) {
        if (this.groups == null) {
            this.groups = new ArrayList<TimelineGroup<G>>();
        }
        this.groups.add(group);
    }

    public void add(TimelineEvent<E> event, TimelineUpdater timelineUpdater) {
        this.events.add(event);
        if (timelineUpdater != null) {
            timelineUpdater.add(event);
        }
    }

    public void addAll(Collection<TimelineEvent<E>> events) {
        this.addAll(events, null);
    }

    public void addAllGroups(Collection<TimelineGroup<G>> groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<TimelineGroup<G>>();
        }
        this.groups.addAll(groups);
    }

    public void addAll(Collection<TimelineEvent<E>> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent<E> event : events) {
                this.add(event, timelineUpdater);
            }
        }
    }

    public void update(TimelineEvent<E> event) {
        this.update(event, null);
    }

    public void update(TimelineEvent<E> event, TimelineUpdater timelineUpdater) {
        int index = IntStream.range(0, this.events.size()).filter(i -> event.equals(this.events.get(i))).findFirst().orElse(-1);
        if (index >= 0) {
            this.events.set(index, event);
            if (timelineUpdater != null) {
                timelineUpdater.update(event);
            }
        }
    }

    public void updateAll(Collection<TimelineEvent<E>> events) {
        this.updateAll(events, null);
    }

    public void updateAll(Collection<TimelineEvent<E>> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent<E> event : events) {
                this.update(event, timelineUpdater);
            }
        }
    }

    public void delete(TimelineEvent<E> event) {
        this.delete(event, null);
    }

    public void delete(TimelineEvent<E> event, TimelineUpdater timelineUpdater) {
        this.events.remove(event);
        if (timelineUpdater != null) {
            timelineUpdater.delete(event.getId());
        }
    }

    public void deleteAll(Collection<TimelineEvent<E>> events) {
        this.deleteAll(events, null);
    }

    public void deleteAll(Collection<TimelineEvent<E>> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent<E> event : events) {
                this.delete(event, timelineUpdater);
            }
        }
    }

    public void select(TimelineEvent<E> event, TimelineUpdater timelineUpdater) {
        if (timelineUpdater != null) {
            timelineUpdater.select(event != null ? event.getId() : null);
        }
    }

    public void clear() {
        this.events.clear();
    }

    public void clear(TimelineUpdater timelineUpdater) {
        this.events.clear();
        if (timelineUpdater != null) {
            timelineUpdater.clear();
        }
    }

    public Set<TimelineEvent<E>> getOverlappedEvents(TimelineEvent<E> event) {
        if (event == null) {
            return Collections.emptySet();
        }
        ArrayList<TimelineEvent<E>> overlappedEvents = null;
        for (TimelineEvent<E> e : this.events) {
            if (e.equals(event) || event.getGroup() == null && e.getGroup() != null || event.getGroup() != null && !event.getGroup().equals(e.getGroup()) || !this.isOverlapping(event, e)) continue;
            if (overlappedEvents == null) {
                overlappedEvents = new ArrayList<TimelineEvent<E>>();
            }
            overlappedEvents.add(e);
        }
        if (overlappedEvents == null) {
            return Collections.emptySet();
        }
        TreeSet orderedOverlappedEvents = new TreeSet(new TimelineEventComparator());
        orderedOverlappedEvents.addAll(overlappedEvents);
        return orderedOverlappedEvents;
    }

    public TimelineEvent<E> merge(TimelineEvent<E> event, Collection<TimelineEvent<E>> events) {
        return this.merge(event, events, null);
    }

    public TimelineEvent<E> merge(TimelineEvent<E> event, Collection<TimelineEvent<E>> events, TimelineUpdater timelineUpdater) {
        if (event == null) {
            return null;
        }
        if (events == null || events.isEmpty()) {
            return event;
        }
        String group = event.getGroup();
        for (TimelineEvent<E> e : events) {
            if ((group != null || e.getGroup() == null) && (group == null || group.equals(e.getGroup()))) continue;
            throw new IllegalStateException("Events to be merged may be only belong to one and the same group!");
        }
        TreeSet<TimelineEvent<E>> orderedEvents = new TreeSet<TimelineEvent<E>>(new TimelineEventComparator());
        orderedEvents.add(event);
        orderedEvents.addAll(events);
        LocalDateTime endDate = orderedEvents.stream().map(TimelineEvent::getEndDate).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null);
        TimelineEvent mergedEvent = TimelineEvent.builder().data(event.getData()).startDate(((TimelineEvent)orderedEvents.first()).getStartDate()).endDate(endDate).editable(event.isEditable()).group(event.getGroup()).styleClass(event.getStyleClass()).build();
        this.deleteAll(events, timelineUpdater);
        this.update(mergedEvent, timelineUpdater);
        return mergedEvent;
    }

    public List<TimelineEvent<E>> getEvents() {
        return this.events;
    }

    public void setEvents(List<TimelineEvent<E>> events) {
        this.events = events;
    }

    public List<TimelineGroup<G>> getGroups() {
        return this.groups;
    }

    public void setGroups(List<TimelineGroup<G>> groups) {
        this.groups = groups;
    }

    public TimelineEvent<E> getEvent(String id) {
        if (id != null) {
            return this.events.stream().filter(event -> id.equals(event.getId())).findAny().orElse(null);
        }
        return null;
    }

    public boolean hasEvent(TimelineEvent<E> event) {
        return this.events.contains(event);
    }

    private boolean isOverlapping(TimelineEvent<E> event1, TimelineEvent<E> event2) {
        if (event1.getEndDate() == null && event2.getEndDate() == null) {
            return event1.getStartDate().equals(event2.getStartDate());
        }
        if (event1.getEndDate() == null && event2.getEndDate() != null) {
            return event1.getStartDate().equals(event2.getStartDate()) || event1.getStartDate().equals(event2.getEndDate()) || event1.getStartDate().isAfter(event2.getStartDate()) && event1.getStartDate().isBefore(event2.getEndDate());
        }
        if (event1.getEndDate() != null && event2.getEndDate() == null) {
            return event2.getStartDate().equals(event1.getStartDate()) || event2.getStartDate().equals(event1.getEndDate()) || event2.getStartDate().isAfter(event1.getStartDate()) && event2.getStartDate().isBefore(event1.getEndDate());
        }
        return event1.getStartDate().equals(event2.getStartDate()) || event1.getStartDate().equals(event2.getEndDate()) || event1.getStartDate().isAfter(event2.getStartDate()) && event1.getStartDate().isBefore(event2.getEndDate()) || event1.getEndDate().equals(event2.getStartDate()) || event1.getEndDate().equals(event2.getEndDate()) || event1.getEndDate().isAfter(event2.getStartDate()) && event1.getEndDate().isBefore(event2.getEndDate()) || event1.getStartDate().isBefore(event2.getStartDate()) && event1.getEndDate().isAfter(event2.getEndDate());
    }
}

