/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.faces.FacesException;

public interface PropertyDescriptorResolver {
    public PropertyDescriptor get(Class<?> var1, String var2);

    public Object getValue(Object var1, String var2);

    public void flush();

    public static class DefaultResolver
    implements PropertyDescriptorResolver {
        private static final Pattern NESTED_EXPRESSION_PATTERN = Pattern.compile("\\.");
        private final Map<String, Map<String, PropertyDescriptor>> pdCache = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();

        @Override
        public PropertyDescriptor get(Class<?> klazz, String expression) {
            PropertyDescriptor pd = null;
            Class<?> parent = klazz;
            for (String field : NESTED_EXPRESSION_PATTERN.split(expression)) {
                pd = this.getSimpleProperty(parent, field);
                parent = pd.getPropertyType();
            }
            return Objects.requireNonNull(pd);
        }

        @Override
        public Object getValue(Object bean, String expression) {
            try {
                for (String field : NESTED_EXPRESSION_PATTERN.split(expression)) {
                    if ((bean = this.getSimpleProperty(bean.getClass(), field).getReadMethod().invoke(bean, new Object[0])) == null) break;
                }
                return bean;
            }
            catch (ReflectiveOperationException e) {
                throw new FacesException((Throwable)e);
            }
        }

        @Override
        public void flush() {
            this.pdCache.clear();
        }

        private PropertyDescriptor getSimpleProperty(Class<?> klazz, String field) {
            String cacheKey = klazz.getName();
            Map classCache = this.pdCache.computeIfAbsent(cacheKey, k -> new ConcurrentHashMap());
            return classCache.computeIfAbsent(field, k -> {
                try {
                    return new PropertyDescriptor((String)k, klazz);
                }
                catch (IntrospectionException e) {
                    throw new FacesException((Throwable)e);
                }
            });
        }
    }
}

