/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.carousel;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.carousel.Carousel;
import org.primefaces.model.ResponsiveOption;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class CarouselRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Carousel carousel = (Carousel)component;
        this.encodeMarkup(context, carousel);
        this.encodeScript(context, carousel);
    }

    private void encodeScript(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        List<ResponsiveOption> responsiveOptions = carousel.getResponsiveOptions();
        wb.init("Carousel", carousel);
        wb.attr("page", carousel.getPage(), 0).attr("circular", carousel.isCircular(), false).attr("autoplayInterval", carousel.getAutoplayInterval(), 0).attr("numVisible", carousel.getNumVisible(), 1).attr("numScroll", carousel.getNumScroll(), 1).attr("orientation", carousel.getOrientation(), "horizontal").attr("touchable", ComponentUtils.isTouchable(context, carousel), true).attr("paginator", carousel.isPaginator(), true).callback("onPageChange", "function(pageValue)", carousel.getOnPageChange());
        if (responsiveOptions != null) {
            writer.write(",responsiveOptions:[");
            for (int i = 0; i < responsiveOptions.size(); ++i) {
                if (i != 0) {
                    writer.write(",");
                }
                responsiveOptions.get(i).encode((Writer)writer);
            }
            writer.write("]");
        }
        this.encodeClientBehaviors(context, carousel);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = carousel.getClientId(context);
        String style = carousel.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-carousel ui-widget").add(carousel.getStyleClass()).add("horizontal".equals(carousel.getOrientation()), "ui-carousel-horizontal").add("vertical".equals(carousel.getOrientation()), "ui-carousel-vertical").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, carousel);
        this.encodeContent(context, carousel);
        this.encodeFooter(context, carousel);
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean isVertical = "vertical".equals(carousel.getOrientation());
        String contentStyleClass = this.getStyleClassBuilder(context).add("ui-carousel-content").add(carousel.getContentStyleClass()).build();
        String containerStyleClass = this.getStyleClassBuilder(context).add("ui-carousel-container").add(carousel.getContainerStyleClass()).build();
        String itemContentHeight = isVertical ? carousel.getVerticalViewPortHeight() : "auto";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)contentStyleClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerStyleClass, null);
        this.encodePrevButton(context, carousel, isVertical);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-items-content", null);
        writer.writeAttribute("style", (Object)("height:" + itemContentHeight), null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-items-container ui-items-hidden", null);
        this.encodeItem(context, carousel);
        writer.endElement("div");
        writer.endElement("div");
        this.encodeNextButton(context, carousel, isVertical);
        writer.endElement("div");
        this.encodeIndicators(context, carousel);
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (carousel.isRepeating()) {
            int rowCount = carousel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                carousel.setIndex(i);
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-carousel-item", "itemStyleClass");
                this.renderChildren(context, (UIComponent)carousel);
                writer.endElement("div");
            }
            carousel.setIndex(-1);
        } else {
            for (UIComponent kid : carousel.getChildren()) {
                if (!kid.isRendered()) continue;
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-carousel-item", "itemStyleClass");
                this.renderChild(context, kid);
                writer.endElement("div");
            }
        }
    }

    protected void encodePrevButton(FacesContext context, Carousel carousel, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String prevButtonIconStyleClass = this.getStyleClassBuilder(context).add("ui-carousel-prev-icon pi").add(!isVertical, "pi-chevron-left").add(isVertical, "pi-chevron-up").build();
        writer.startElement("button", null);
        writer.writeAttribute("class", (Object)"ui-carousel-prev ui-link", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)prevButtonIconStyleClass, null);
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeNextButton(FacesContext context, Carousel carousel, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String nextButtonIconStyleClass = this.getStyleClassBuilder(context).add("ui-carousel-next-icon pi").add(!isVertical, "pi-chevron-right").add(isVertical, "pi-chevron-down").build();
        writer.startElement("button", null);
        writer.writeAttribute("class", (Object)"ui-carousel-next ui-link", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)nextButtonIconStyleClass, null);
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeIndicators(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String indicatorsContentStyleClass = this.getStyleClassBuilder(context).add("ui-carousel-indicators ui-reset").add(carousel.getIndicatorsContentStyleClass()).build();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)indicatorsContentStyleClass, null);
        writer.endElement("ul");
    }

    protected void encodeHeader(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String headerText = carousel.getHeaderText();
        UIComponent facet = carousel.getFacet("header");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (headerText == null && !shouldRenderFacet) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-header", null);
        if (shouldRenderFacet) {
            facet.encodeAll(context);
        } else {
            writer.writeText((Object)headerText, "headerText");
        }
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String footerText = carousel.getFooterText();
        UIComponent facet = carousel.getFacet("footer");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (footerText == null && !shouldRenderFacet) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-footer", null);
        if (shouldRenderFacet) {
            facet.encodeAll(context);
        } else {
            writer.writeText((Object)footerText, "footerText");
        }
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }
}

