/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.component.fileupload.ContentRange;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.component.fileupload.FileUploadChunkDecoder;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.model.file.NIOUploadedFile;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFileWrapper;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.model.file.UploadedFilesWrapper;
import org.primefaces.util.FileUploadUtils;

public abstract class AbstractFileUploadDecoder<T extends HttpServletRequest>
implements FileUploadDecoder,
FileUploadChunkDecoder<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractFileUploadDecoder.class.getName());

    @Override
    public void decode(FacesContext context, FileUpload fileUpload) {
        T request = this.getRequest(context);
        try {
            String inputToDecodeId = this.resolveInputToDecodeId(context, fileUpload);
            if (fileUpload.getMode().equals("simple")) {
                this.decodeSimple(fileUpload, request, inputToDecodeId);
            } else {
                this.decodeAdvanced(fileUpload, request, inputToDecodeId);
            }
        }
        catch (IOException | ServletException e) {
            throw new FacesException(e);
        }
    }

    protected void decodeSimple(FileUpload fileUpload, T request, String inputToDecodeId) throws IOException, ServletException {
        if (fileUpload.isMultiple()) {
            List<UploadedFile> files = this.createUploadedFiles(request, fileUpload, inputToDecodeId);
            if (!files.isEmpty()) {
                UploadedFiles uploadedFiles = new UploadedFiles(files);
                fileUpload.setSubmittedValue(new UploadedFilesWrapper(uploadedFiles));
            } else {
                fileUpload.setSubmittedValue("");
            }
        } else {
            UploadedFile uploadedFile = this.createUploadedFile(request, fileUpload, inputToDecodeId);
            if (uploadedFile != null) {
                fileUpload.setSubmittedValue(new UploadedFileWrapper(uploadedFile));
            } else {
                fileUpload.setSubmittedValue("");
            }
        }
    }

    protected void decodeAdvanced(FileUpload fileUpload, T request, String inputToDecodeId) throws IOException, ServletException {
        UploadedFile uploadedFile = this.createUploadedFile(request, fileUpload, inputToDecodeId);
        if (uploadedFile != null) {
            if (this.isChunkedUpload(request)) {
                this.decodeContentRange(fileUpload, request, uploadedFile);
            } else {
                fileUpload.setSubmittedValue(new UploadedFileWrapper(uploadedFile));
            }
        }
    }

    protected String resolveInputToDecodeId(FacesContext context, FileUpload fileUpload) {
        String clientId = fileUpload.getClientId(context);
        String mode = fileUpload.getMode();
        if ("advanced".equals(mode) || "simple".equals(mode) && !fileUpload.isSkinSimple()) {
            return clientId;
        }
        return clientId + "_input";
    }

    protected abstract List<UploadedFile> createUploadedFiles(T var1, FileUpload var2, String var3) throws IOException, ServletException;

    protected abstract UploadedFile createUploadedFile(T var1, FileUpload var2, String var3) throws IOException, ServletException;

    protected abstract T getRequest(FacesContext var1);

    @Override
    public void decodeContentRange(FileUpload fileUpload, T request, UploadedFile chunk) throws IOException {
        ContentRange contentRange = ContentRange.of(this.getContentRange((HttpServletRequest)request), fileUpload.getMaxChunkSize());
        Path chunksDir = FileUploadUtils.getChunkDir(request);
        this.writeChunk(chunk, chunksDir, contentRange);
        if (contentRange.isLastChunk()) {
            UploadedFile uploadedFile = this.processLastChunk(request, chunk, chunksDir, contentRange, fileUpload.getSizeLimit());
            request.setAttribute("org.primefaces.file.multiParts", (Object)uploadedFile);
            fileUpload.setSubmittedValue(new UploadedFileWrapper(uploadedFile));
        }
    }

    @Override
    public long decodeUploadedBytes(T request) {
        long uploadedBytes = 0L;
        for (Path chunk : FileUploadUtils.listChunks(request)) {
            try {
                uploadedBytes += Files.size(chunk);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                break;
            }
        }
        return uploadedBytes;
    }

    @Override
    public void deleteChunks(T request) throws IOException {
        Path chunkDir = FileUploadUtils.getChunkDir(request);
        List<Path> chunks = FileUploadUtils.listChunks(chunkDir);
        this.deleteChunkFolder(chunkDir, chunks);
    }

    protected void writeChunk(UploadedFile uploadedFile, Path path, ContentRange contentRange) throws IOException {
        if (!path.toFile().exists()) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        String chunkname = String.valueOf(contentRange.getPacket());
        Path chunkFile = Paths.get(path.toFile().getAbsolutePath(), chunkname);
        try (InputStream is = uploadedFile.getInputStream();){
            Files.copy(is, chunkFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected UploadedFile processLastChunk(T request, UploadedFile chunk, Path chunksDir, ContentRange contentRange, Long sizeLimit) throws IOException {
        String fileKey = this.generateFileInfoKey(request);
        Path whole = Paths.get(this.getUploadDirectory(request), "[" + fileKey + "]" + chunk.getFileName());
        Files.deleteIfExists(whole);
        Files.createFile(whole, new FileAttribute[0]);
        List<Path> chunks = FileUploadUtils.listChunks(chunksDir);
        for (Path p : chunks) {
            Files.write(whole, Files.readAllBytes(p), StandardOpenOption.APPEND);
        }
        this.deleteChunkFolder(chunksDir, chunks);
        if (Files.size(whole) != contentRange.getChunkTotalFileSize()) {
            Files.delete(whole);
            throw new IOException("Merged file does not meet expected size: " + contentRange.getChunkTotalFileSize());
        }
        return new NIOUploadedFile(whole, chunk.getFileName(), chunk.getContentType(), sizeLimit, FileUploadUtils.getWebkitRelativePath(request));
    }

    protected String getContentRange(HttpServletRequest request) {
        return request.getHeader("Content-Range");
    }

    protected void deleteChunkFolder(Path chunksDir, List<Path> chunks) throws IOException {
        for (Path p : chunks) {
            Files.delete(p);
        }
        Files.delete(chunksDir);
    }

    protected boolean isChunkedUpload(T request) {
        return this.getContentRange((HttpServletRequest)request) != null;
    }
}

