/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rating;

import java.io.IOException;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.rating.Rating;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class RatingRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Rating rating = (Rating)component;
        if (!this.shouldDecode(rating)) {
            return;
        }
        String clientId = rating.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (LangUtils.isNotEmpty(submittedValue)) {
            int submittedStars = Integer.parseInt(submittedValue);
            if (submittedStars == 0) {
                submittedValue = null;
            } else if (submittedStars < 1 || submittedStars > rating.getStars()) {
                return;
            }
        }
        rating.setSubmittedValue(submittedValue);
        this.decodeBehaviors(context, (UIComponent)rating);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Rating rating = (Rating)component;
        this.encodeMarkup(context, rating);
        this.encodeScript(context, rating);
    }

    private void encodeScript(FacesContext context, Rating rating) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Rating", rating).callback("onRate", "function(value)", rating.getOnRate()).attr("readonly", rating.isReadonly(), false).attr("disabled", rating.isDisabled(), false);
        this.encodeClientBehaviors(context, rating);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Rating rating) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = rating.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)rating);
        Integer value = this.isValueBlank(valueToRender) ? null : Integer.valueOf(valueToRender);
        int stars = rating.getStars();
        boolean disabled = rating.isDisabled();
        boolean readonly = rating.isReadonly();
        String style = rating.getStyle();
        Object styleClass = rating.getStyleClass();
        Object object = styleClass = styleClass == null ? "ui-rating" : "ui-rating " + (String)styleClass;
        if (disabled) {
            styleClass = (String)styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)rating);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeInput(context, rating, clientId + "_input", valueToRender);
        if (rating.isCancel() && !disabled && !readonly) {
            this.encodeIcon(context, "ui-rating-cancel");
        }
        for (int i = 0; i < stars; ++i) {
            String starClass = value != null && i < value ? "ui-rating-star ui-rating-star-on" : "ui-rating-star";
            this.encodeIcon(context, starClass);
        }
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("a", null);
        writer.endElement("a");
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, Rating rating, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"range", null);
        writer.writeAttribute("min", (Object)"0", null);
        writer.writeAttribute("max", (Object)rating.getStars(), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", (Object)Objects.toString(value, "0"), null);
        writer.writeAttribute("tabindex", (Object)rating.getTabindex(), null);
        if (rating.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

