/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.badge;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.badge.Badge;
import org.primefaces.model.badge.BadgeModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.IOBiConsumer;
import org.primefaces.util.LangUtils;

public class BadgeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Badge badge = (Badge)component;
        boolean hasChildren = badge.getChildCount() > 0;
        this.encode(context, badge, null, hasChildren);
    }

    public static <T extends UIComponent> void encodeOverlayed(FacesContext context, Object badge, IOBiConsumer<FacesContext, T> contentRenderer, T component) throws IOException {
        BadgeModel badgeModel = Badge.getBadgeModel(badge);
        if (badgeModel != null) {
            BadgeRenderer badgeRenderer = Badge.create(context).getRenderer();
            badgeRenderer.encodeOverlayBegin(context, null);
            contentRenderer.accept(context, (FacesContext)component);
            badgeRenderer.encode(context, null, badgeModel, false);
            badgeRenderer.encodeOverlayEnd(context);
        } else {
            contentRenderer.accept(context, (FacesContext)component);
        }
    }

    public static void encode(FacesContext context, Object badge) throws IOException {
        BadgeModel badgeModel = Badge.getBadgeModel(badge);
        if (badgeModel != null) {
            BadgeRenderer badgeRenderer = Badge.create(context).getRenderer();
            badgeRenderer.encode(context, null, badgeModel, false);
        }
    }

    protected void encodeOverlayBegin(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        if (clientId != null) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        writer.writeAttribute("class", (Object)"ui-overlay-badge", "styleClass");
    }

    protected void encodeOverlayEnd(FacesContext context) throws IOException {
        context.getResponseWriter().endElement("div");
    }

    protected void encode(FacesContext context, Badge badge, BadgeModel badgeModel, boolean renderChildren) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BadgeModel model = badgeModel;
        if (model == null) {
            model = badge.toBadgeModel();
        }
        String clientId = badge == null ? null : badge.getClientId(context);
        String value = model.getValue();
        boolean valueEmpty = LangUtils.isEmpty(value);
        String severity = model.getSeverity();
        String icon = model.getIcon();
        boolean iconEmpty = LangUtils.isEmpty(icon);
        String size = model.getSize();
        String styleClass = this.getStyleClassBuilder(context).add("ui-badge ui-widget").add(model.getStyleClass()).add(!valueEmpty && value.length() == 1, "ui-badge-no-gutter").add(valueEmpty && iconEmpty, "ui-badge-dot").add(!model.isVisible(), "ui-state-hidden").add("large".equals(size), "ui-badge-lg").add("xlarge".equals(size), "ui-badge-xl").add("info".equals(severity), "ui-badge-info").add("success".equals(severity), "ui-badge-success").add("warning".equals(severity), "ui-badge-warning").add("danger".equals(severity), "ui-badge-danger").build();
        if (renderChildren) {
            this.encodeOverlayBegin(context, clientId);
        }
        writer.startElement("span", null);
        if (!renderChildren && clientId != null) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (model.getStyle() != null) {
            writer.writeAttribute("style", (Object)model.getStyle(), "style");
        }
        if (model.getOnclick() != null) {
            writer.writeAttribute("onclick", (Object)model.getOnclick(), "onclick");
        } else if (renderChildren) {
            writer.writeAttribute("onclick", (Object)"$(this).next().click();", "onclick");
        }
        this.encodeValue(context, badge, model);
        writer.endElement("span");
        if (renderChildren) {
            this.renderChildren(context, (UIComponent)badge);
            this.encodeOverlayEnd(context);
        }
    }

    protected void encodeValue(FacesContext context, Badge badge, BadgeModel model) throws IOException {
        if (!model.isVisible()) {
            return;
        }
        String value = model.getValue();
        boolean valueEmpty = LangUtils.isEmpty(value);
        String icon = model.getIcon();
        boolean iconEmpty = LangUtils.isEmpty(icon);
        String iconPos = model.getIconPos();
        if (iconEmpty) {
            this.encodeLabel(context, badge, value, valueEmpty);
            return;
        }
        if ("left".equalsIgnoreCase(iconPos)) {
            this.encodeIcon(context, badge, icon);
            this.encodeLabel(context, badge, value, valueEmpty);
        } else {
            this.encodeLabel(context, badge, value, valueEmpty);
            this.encodeIcon(context, badge, icon);
        }
    }

    protected void encodeIcon(FacesContext context, Badge badge, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconStyleClass = this.getStyleClassBuilder(context).add("ui-badge-icon").add(icon).build();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconStyleClass, null);
        writer.endElement("span");
    }

    protected void encodeLabel(FacesContext context, Badge badge, String value, boolean valueEmpty) throws IOException {
        if (!valueEmpty) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-badge-label", null);
            writer.writeText((Object)value, "value");
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

