/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.barchart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.barchart.BarChart;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.model.charts.bar.BarChartOptions;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class BarChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BarChart chart = (BarChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, BarChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("BarChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        BarChartOptions barOptions = (BarChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeResponsive(context, barOptions, false);
        writer.write(",\"barPercentage\":" + barOptions.getBarPercentage());
        if (LangUtils.isNotBlank(barOptions.getIndexAxis())) {
            writer.write(",\"indexAxis\":\"" + barOptions.getIndexAxis() + "\"");
        }
        if (barOptions.getCategoryPercentage() != null) {
            writer.write(",\"categoryPercentage\":" + barOptions.getCategoryPercentage());
        }
        if (barOptions.getBarThickness() != null) {
            writer.write(",\"barThickness\":" + barOptions.getBarThickness());
        }
        if (barOptions.getMaxBarThickness() != null) {
            writer.write(",\"maxBarThickness\":" + barOptions.getMaxBarThickness());
        }
        this.encodeScales(context, type, barOptions.getScales(), true);
        this.encodeElements(context, barOptions.getElements(), true);
        this.encodeAnimation(context, barOptions.getAnimation(), true);
        this.encodePlugins(context, barOptions, true);
        writer.write("}");
    }
}

