/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.celleditor;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.renderkit.CoreRenderer;

public class CellEditorRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CellEditor editor = (CellEditor)component;
        UIComponent parentTable = editor.getParentTable(context);
        boolean isLazyEdit = false;
        if (editor.isDisabled()) {
            editor.getFacet("output").encodeAll(context);
            return;
        }
        if (parentTable != null) {
            String editMode = null;
            String cellEditMode = null;
            boolean isLazyRowEdit = false;
            if (parentTable instanceof DataTable) {
                DataTable dt = (DataTable)parentTable;
                editMode = dt.getEditMode();
                cellEditMode = dt.getCellEditMode();
                String rowEditMode = dt.getRowEditMode();
                isLazyRowEdit = "row".equals(editMode) && "lazy".equals(rowEditMode) && !dt.isRowEditInitRequest(context) && !context.isValidationFailed();
            } else if (parentTable instanceof TreeTable) {
                TreeTable tt = (TreeTable)parentTable;
                editMode = tt.getEditMode();
                cellEditMode = tt.getCellEditMode();
            }
            isLazyEdit = "cell".equals(editMode) && "lazy".equals(cellEditMode) || isLazyRowEdit;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.writeAttribute("class", (Object)"ui-cell-editor", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-cell-editor-output", null);
        editor.getFacet("output").encodeAll(context);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-cell-editor-input", null);
        if (!isLazyEdit) {
            editor.getFacet("input").encodeAll(context);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

